/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.optimizations.PlanNodeDecorrelator;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ScalarAggregationToJoinRewriter {
    private static final QualifiedName COUNT = QualifiedName.of((String)"count");
    private final FunctionManager functionManager;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Lookup lookup;
    private final PlanNodeDecorrelator planNodeDecorrelator;

    public ScalarAggregationToJoinRewriter(FunctionManager functionManager, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Lookup lookup) {
        this.functionManager = Objects.requireNonNull(functionManager, "metadata is null");
        this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        this.planNodeDecorrelator = new PlanNodeDecorrelator(idAllocator, lookup);
    }

    public PlanNode rewriteScalarAggregation(LateralJoinNode lateralJoinNode, AggregationNode aggregation) {
        List<Symbol> correlation = lateralJoinNode.getCorrelation();
        Optional<PlanNodeDecorrelator.DecorrelatedNode> source = this.planNodeDecorrelator.decorrelateFilters(this.lookup.resolve(aggregation.getSource()), correlation);
        if (!source.isPresent()) {
            return lateralJoinNode;
        }
        Symbol nonNull = this.symbolAllocator.newSymbol("non_null", (Type)BooleanType.BOOLEAN);
        Assignments scalarAggregationSourceAssignments = Assignments.builder().putIdentities(source.get().getNode().getOutputSymbols()).put(nonNull, (Expression)BooleanLiteral.TRUE_LITERAL).build();
        ProjectNode scalarAggregationSourceWithNonNullableSymbol = new ProjectNode(this.idAllocator.getNextId(), source.get().getNode(), scalarAggregationSourceAssignments);
        return this.rewriteScalarAggregation(lateralJoinNode, aggregation, scalarAggregationSourceWithNonNullableSymbol, source.get().getCorrelatedPredicates(), nonNull);
    }

    private PlanNode rewriteScalarAggregation(LateralJoinNode lateralJoinNode, AggregationNode scalarAggregation, PlanNode scalarAggregationSource, Optional<Expression> joinExpression, Symbol nonNull) {
        AssignUniqueId inputWithUniqueColumns = new AssignUniqueId(this.idAllocator.getNextId(), lateralJoinNode.getInput(), this.symbolAllocator.newSymbol("unique", (Type)BigintType.BIGINT));
        JoinNode leftOuterJoin = new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.LEFT, inputWithUniqueColumns, scalarAggregationSource, (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.builder().addAll(inputWithUniqueColumns.getOutputSymbols()).addAll(scalarAggregationSource.getOutputSymbols()).build(), joinExpression, Optional.empty(), Optional.empty(), Optional.empty());
        Optional<AggregationNode> aggregationNode = this.createAggregationNode(scalarAggregation, leftOuterJoin, nonNull);
        if (!aggregationNode.isPresent()) {
            return lateralJoinNode;
        }
        Optional subqueryProjection = PlanNodeSearcher.searchFrom(lateralJoinNode.getSubquery(), this.lookup).where(ProjectNode.class::isInstance).recurseOnlyWhen(EnforceSingleRowNode.class::isInstance).findFirst();
        List<Symbol> aggregationOutputSymbols = ScalarAggregationToJoinRewriter.getTruncatedAggregationSymbols(lateralJoinNode, aggregationNode.get());
        if (subqueryProjection.isPresent()) {
            Assignments assignments = Assignments.builder().putIdentities(aggregationOutputSymbols).putAll(((ProjectNode)subqueryProjection.get()).getAssignments()).build();
            return new ProjectNode(this.idAllocator.getNextId(), aggregationNode.get(), assignments);
        }
        return new ProjectNode(this.idAllocator.getNextId(), aggregationNode.get(), Assignments.identity(aggregationOutputSymbols));
    }

    private static List<Symbol> getTruncatedAggregationSymbols(LateralJoinNode lateralJoinNode, AggregationNode aggregationNode) {
        HashSet<Symbol> applySymbols = new HashSet<Symbol>(lateralJoinNode.getOutputSymbols());
        return (List)aggregationNode.getOutputSymbols().stream().filter(applySymbols::contains).collect(ImmutableList.toImmutableList());
    }

    private Optional<AggregationNode> createAggregationNode(AggregationNode scalarAggregation, JoinNode leftOuterJoin, Symbol nonNullableAggregationSourceSymbol) {
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : scalarAggregation.getAggregations().entrySet()) {
            FunctionCall call = entry.getValue().getCall();
            Symbol symbol = entry.getKey();
            if (call.getName().equals((Object)COUNT)) {
                ImmutableList scalarAggregationSourceTypeSignatures = ImmutableList.of((Object)this.symbolAllocator.getTypes().get(nonNullableAggregationSourceSymbol).getTypeSignature());
                aggregations.put((Object)symbol, (Object)new AggregationNode.Aggregation(new FunctionCall(COUNT, (List)ImmutableList.of((Object)nonNullableAggregationSourceSymbol.toSymbolReference())), this.functionManager.lookupFunction(COUNT, TypeSignatureProvider.fromTypeSignatures((List<? extends TypeSignature>)scalarAggregationSourceTypeSignatures)), entry.getValue().getMask()));
                continue;
            }
            aggregations.put((Object)symbol, (Object)entry.getValue());
        }
        return Optional.of(new AggregationNode(this.idAllocator.getNextId(), leftOuterJoin, (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), AggregationNode.singleGroupingSet(leftOuterJoin.getLeft().getOutputSymbols()), (List<Symbol>)ImmutableList.of(), scalarAggregation.getStep(), scalarAggregation.getHashSymbol(), Optional.empty()));
    }
}

