/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorSignatureUtils;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeRef;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.airlift.slice.Slice;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExpressionEquivalence {
    private static final Ordering<RowExpression> ROW_EXPRESSION_ORDERING = Ordering.from((Comparator)new RowExpressionComparator());
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final CanonicalizationVisitor canonicalizationVisitor;

    public ExpressionEquivalence(Metadata metadata, SqlParser sqlParser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.canonicalizationVisitor = new CanonicalizationVisitor(metadata.getFunctionManager());
    }

    public boolean areExpressionsEquivalent(Session session, Expression leftExpression, Expression rightExpression, TypeProvider types) {
        HashMap<Symbol, Integer> symbolInput = new HashMap<Symbol, Integer>();
        int inputId = 0;
        for (Map.Entry<Symbol, Type> entry : types.allTypes().entrySet()) {
            symbolInput.put(entry.getKey(), inputId);
            ++inputId;
        }
        RowExpression leftRowExpression = this.toRowExpression(session, leftExpression, symbolInput, types);
        RowExpression rightRowExpression = this.toRowExpression(session, rightExpression, symbolInput, types);
        RowExpression canonicalizedLeft = (RowExpression)leftRowExpression.accept((RowExpressionVisitor)this.canonicalizationVisitor, null);
        RowExpression canonicalizedRight = (RowExpression)rightRowExpression.accept((RowExpressionVisitor)this.canonicalizationVisitor, null);
        return canonicalizedLeft.equals((Object)canonicalizedRight);
    }

    private RowExpression toRowExpression(Session session, Expression expression, Map<Symbol, Integer> symbolInput, TypeProvider types) {
        Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(session, this.metadata, this.sqlParser, types, expression, Collections.emptyList(), WarningCollector.NOOP);
        return SqlToRowExpressionTranslator.translate(expression, expressionTypes, symbolInput, this.metadata.getFunctionManager(), this.metadata.getTypeManager(), session, false);
    }

    private static <T> List<T> swapPair(List<T> pair) {
        Objects.requireNonNull(pair, "pair is null");
        Preconditions.checkArgument((pair.size() == 2 ? 1 : 0) != 0, (Object)"Expected pair to have two elements");
        return ImmutableList.of(pair.get(1), pair.get(0));
    }

    private static class ListComparator<T>
    implements Comparator<List<T>> {
        private final Comparator<T> elementComparator;

        public ListComparator(Comparator<T> elementComparator) {
            this.elementComparator = Objects.requireNonNull(elementComparator, "elementComparator is null");
        }

        @Override
        public int compare(List<T> left, List<T> right) {
            int compareLength = Integer.min(left.size(), right.size());
            for (int i = 0; i < compareLength; ++i) {
                int result = this.elementComparator.compare(left.get(i), right.get(i));
                if (result == 0) continue;
                return result;
            }
            return Integer.compare(left.size(), right.size());
        }
    }

    private static class RowExpressionComparator
    implements Comparator<RowExpression> {
        private final Comparator<Object> classComparator = Ordering.arbitrary();
        private final ListComparator<RowExpression> argumentComparator = new ListComparator<RowExpression>(this);

        private RowExpressionComparator() {
        }

        @Override
        public int compare(RowExpression left, RowExpression right) {
            int result = this.classComparator.compare(left.getClass(), right.getClass());
            if (result != 0) {
                return result;
            }
            if (left instanceof CallExpression) {
                CallExpression leftCall = (CallExpression)left;
                CallExpression rightCall = (CallExpression)right;
                return ComparisonChain.start().compare((Comparable)((Object)leftCall.getFunctionHandle().toString()), (Comparable)((Object)rightCall.getFunctionHandle().toString())).compare((Object)leftCall.getArguments(), (Object)rightCall.getArguments(), this.argumentComparator).result();
            }
            if (left instanceof ConstantExpression) {
                ConstantExpression leftConstant = (ConstantExpression)left;
                ConstantExpression rightConstant = (ConstantExpression)right;
                result = leftConstant.getType().getTypeSignature().toString().compareTo(right.getType().getTypeSignature().toString());
                if (result != 0) {
                    return result;
                }
                Object leftValue = leftConstant.getValue();
                Object rightValue = rightConstant.getValue();
                if (leftValue == null) {
                    if (rightValue == null) {
                        return 0;
                    }
                    return -1;
                }
                if (rightValue == null) {
                    return 1;
                }
                Class javaType = leftConstant.getType().getJavaType();
                if (javaType == Boolean.TYPE) {
                    return ((Boolean)leftValue).compareTo((Boolean)rightValue);
                }
                if (javaType == Byte.TYPE || javaType == Short.TYPE || javaType == Integer.TYPE || javaType == Long.TYPE) {
                    return Long.compare(((Number)leftValue).longValue(), ((Number)rightValue).longValue());
                }
                if (javaType == Float.TYPE || javaType == Double.TYPE) {
                    return Double.compare(((Number)leftValue).doubleValue(), ((Number)rightValue).doubleValue());
                }
                if (javaType == Slice.class) {
                    return ((Slice)leftValue).compareTo((Slice)rightValue);
                }
                return -1;
            }
            if (left instanceof InputReferenceExpression) {
                return Integer.compare(((InputReferenceExpression)left).getField(), ((InputReferenceExpression)right).getField());
            }
            if (left instanceof LambdaDefinitionExpression) {
                LambdaDefinitionExpression leftLambda = (LambdaDefinitionExpression)left;
                LambdaDefinitionExpression rightLambda = (LambdaDefinitionExpression)right;
                return ComparisonChain.start().compare((Object)leftLambda.getArgumentTypes(), (Object)rightLambda.getArgumentTypes(), new ListComparator<Type>(Comparator.comparing(Object::toString))).compare((Object)leftLambda.getArguments(), (Object)rightLambda.getArguments(), new ListComparator(Comparator.naturalOrder())).compare((Object)leftLambda.getBody(), (Object)rightLambda.getBody(), (Comparator)this).result();
            }
            if (left instanceof VariableReferenceExpression) {
                VariableReferenceExpression leftVariableReference = (VariableReferenceExpression)left;
                VariableReferenceExpression rightVariableReference = (VariableReferenceExpression)right;
                return ComparisonChain.start().compare((Comparable)((Object)leftVariableReference.getName()), (Comparable)((Object)rightVariableReference.getName())).compare((Object)leftVariableReference.getType(), (Object)rightVariableReference.getType(), Comparator.comparing(Object::toString)).result();
            }
            if (left instanceof SpecialFormExpression) {
                SpecialFormExpression leftSpecialForm = (SpecialFormExpression)left;
                SpecialFormExpression rightSpecialForm = (SpecialFormExpression)right;
                return ComparisonChain.start().compare((Comparable)leftSpecialForm.getForm(), (Comparable)rightSpecialForm.getForm()).compare((Object)leftSpecialForm.getType(), (Object)rightSpecialForm.getType(), Comparator.comparing(Object::toString)).compare((Object)leftSpecialForm.getArguments(), (Object)rightSpecialForm.getArguments(), this.argumentComparator).result();
            }
            throw new IllegalArgumentException("Unsupported RowExpression type " + left.getClass().getSimpleName());
        }
    }

    private static class CanonicalizationVisitor
    implements RowExpressionVisitor<RowExpression, Void> {
        private final FunctionManager functionManager;

        public CanonicalizationVisitor(FunctionManager functionManager) {
            this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        }

        public RowExpression visitCall(CallExpression call, Void context) {
            String callName = (call = new CallExpression(call.getFunctionHandle(), call.getType(), (List)call.getArguments().stream().map(expression -> (RowExpression)expression.accept((RowExpressionVisitor)this, (Object)context)).collect(ImmutableList.toImmutableList()))).getFunctionHandle().getSignature().getName();
            if (callName.equals(OperatorSignatureUtils.mangleOperatorName(OperatorType.EQUAL)) || callName.equals(OperatorSignatureUtils.mangleOperatorName(OperatorType.NOT_EQUAL)) || callName.equals(OperatorSignatureUtils.mangleOperatorName(OperatorType.IS_DISTINCT_FROM))) {
                return new CallExpression(call.getFunctionHandle(), call.getType(), ROW_EXPRESSION_ORDERING.sortedCopy((Iterable)call.getArguments()));
            }
            if (callName.equals(OperatorSignatureUtils.mangleOperatorName(OperatorType.GREATER_THAN)) || callName.equals(OperatorSignatureUtils.mangleOperatorName(OperatorType.GREATER_THAN_OR_EQUAL))) {
                FunctionHandle functionHandle = this.functionManager.resolveOperator(callName.equals(OperatorSignatureUtils.mangleOperatorName(OperatorType.GREATER_THAN)) ? OperatorType.LESS_THAN : OperatorType.LESS_THAN_OR_EQUAL, ExpressionEquivalence.swapPair(TypeSignatureProvider.fromTypes((List)call.getArguments().stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList()))));
                return new CallExpression(functionHandle, call.getType(), ExpressionEquivalence.swapPair(call.getArguments()));
            }
            return call;
        }

        public static List<RowExpression> flattenNestedSpecialForms(SpecialFormExpression specialForm) {
            SpecialFormExpression.Form form = specialForm.getForm();
            ImmutableList.Builder newArguments = ImmutableList.builder();
            for (RowExpression argument : specialForm.getArguments()) {
                if (argument instanceof SpecialFormExpression && form.equals((Object)((SpecialFormExpression)argument).getForm())) {
                    newArguments.addAll(CanonicalizationVisitor.flattenNestedSpecialForms((SpecialFormExpression)argument));
                    continue;
                }
                newArguments.add((Object)argument);
            }
            return newArguments.build();
        }

        public RowExpression visitConstant(ConstantExpression constant, Void context) {
            return constant;
        }

        public RowExpression visitInputReference(InputReferenceExpression node, Void context) {
            return node;
        }

        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return new LambdaDefinitionExpression(lambda.getArgumentTypes(), lambda.getArguments(), (RowExpression)lambda.getBody().accept((RowExpressionVisitor)this, (Object)context));
        }

        public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
            return reference;
        }

        public RowExpression visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            if ((specialForm = new SpecialFormExpression(specialForm.getForm(), specialForm.getType(), (List)specialForm.getArguments().stream().map(expression -> (RowExpression)expression.accept((RowExpressionVisitor)this, (Object)context)).collect(ImmutableList.toImmutableList()))).getForm() == SpecialFormExpression.Form.AND || specialForm.getForm() == SpecialFormExpression.Form.OR) {
                List<RowExpression> flattenedArguments = CanonicalizationVisitor.flattenNestedSpecialForms(specialForm);
                ImmutableSet distinctArguments = ImmutableSet.copyOf(flattenedArguments);
                if (distinctArguments.size() == 1) {
                    return (RowExpression)Iterables.getOnlyElement((Iterable)distinctArguments);
                }
                List sortedArguments = ROW_EXPRESSION_ORDERING.sortedCopy((Iterable)distinctArguments);
                return new SpecialFormExpression(specialForm.getForm(), (Type)BooleanType.BOOLEAN, sortedArguments);
            }
            return specialForm;
        }
    }
}

