/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.operator.scalar.TryFunction;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.LookupSymbolResolver;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolsExtractor;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PreconditionRules;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NullLiteral;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PickTableLayout {
    private final Metadata metadata;
    private final SqlParser parser;
    private final DomainTranslator domainTranslator;

    public PickTableLayout(Metadata metadata, SqlParser parser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.parser = Objects.requireNonNull(parser, "parser is null");
        this.domainTranslator = new DomainTranslator(new LiteralEncoder(metadata.getBlockEncodingSerde()));
    }

    public Set<Rule<?>> rules() {
        return ImmutableSet.of(PreconditionRules.checkRulesAreFiredBeforeAddExchangesRule(), (Object)this.pickTableLayoutForPredicate(), (Object)this.pickTableLayoutWithoutPredicate());
    }

    public PickTableLayoutForPredicate pickTableLayoutForPredicate() {
        return new PickTableLayoutForPredicate(this.metadata, this.parser, this.domainTranslator);
    }

    public PickTableLayoutWithoutPredicate pickTableLayoutWithoutPredicate() {
        return new PickTableLayoutWithoutPredicate(this.metadata, this.parser, this.domainTranslator);
    }

    private static PlanNode planTableScan(TableScanNode node, Expression predicate, Session session, TypeProvider types, PlanNodeIdAllocator idAllocator, Metadata metadata, SqlParser parser, DomainTranslator domainTranslator) {
        return PickTableLayout.listTableLayouts(node, predicate, false, session, types, idAllocator, metadata, parser, domainTranslator).get(0);
    }

    public static List<PlanNode> listTableLayouts(TableScanNode node, Expression predicate, boolean pruneWithPredicateExpression, Session session, TypeProvider types, PlanNodeIdAllocator idAllocator, Metadata metadata, SqlParser parser, DomainTranslator domainTranslator) {
        List<TableLayoutResult> layouts;
        Constraint constraint;
        Expression deterministicPredicate = ExpressionUtils.filterDeterministicConjuncts(predicate);
        DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.fromPredicate(metadata, session, deterministicPredicate, types);
        TupleDomain newDomain = decomposedPredicate.getTupleDomain().transform(node.getAssignments()::get).intersect(node.getEnforcedConstraint());
        ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
        if (pruneWithPredicateExpression) {
            Expression[] expressionArray = new Expression[2];
            expressionArray[0] = deterministicPredicate;
            expressionArray[1] = domainTranslator.toPredicate((TupleDomain<Symbol>)newDomain.simplify().transform(((Map)assignments)::get));
            LayoutConstraintEvaluator evaluator = new LayoutConstraintEvaluator(metadata, parser, session, types, node.getAssignments(), ExpressionUtils.combineConjuncts(expressionArray));
            constraint = new Constraint(newDomain, x$0 -> evaluator.isCandidate(x$0));
        } else {
            constraint = new Constraint(newDomain);
        }
        if ((layouts = metadata.getLayouts(session, node.getTable(), (Constraint<ColumnHandle>)constraint, Optional.of(node.getOutputSymbols().stream().map(node.getAssignments()::get).collect(ImmutableSet.toImmutableSet())))).isEmpty()) {
            return ImmutableList.of((Object)new ValuesNode(idAllocator.getNextId(), node.getOutputSymbols(), (List<List<RowExpression>>)ImmutableList.of()));
        }
        Preconditions.checkState((!(layouts = layouts.stream().filter(layout -> layout.hasAllOutputs(node)).collect(Collectors.toList())).isEmpty() ? 1 : 0) != 0, (String)"No usable layouts for %s", (Object)node);
        if (layouts.stream().anyMatch(layout -> layout.getLayout().getPredicate().isNone())) {
            return ImmutableList.of((Object)new ValuesNode(idAllocator.getNextId(), node.getOutputSymbols(), (List<List<RowExpression>>)ImmutableList.of()));
        }
        return (List)layouts.stream().map(arg_0 -> PickTableLayout.lambda$listTableLayouts$3(node, newDomain, domainTranslator, (Map)assignments, predicate, decomposedPredicate, idAllocator, arg_0)).collect(ImmutableList.toImmutableList());
    }

    private static /* synthetic */ PlanNode lambda$listTableLayouts$3(TableScanNode node, TupleDomain newDomain, DomainTranslator domainTranslator, Map assignments, Expression predicate, DomainTranslator.ExtractionResult decomposedPredicate, PlanNodeIdAllocator idAllocator, TableLayoutResult layout) {
        TableScanNode tableScan = new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), Optional.of(layout.getLayout().getHandle()), layout.getLayout().getPredicate(), TableLayoutResult.computeEnforced((TupleDomain<ColumnHandle>)newDomain, layout.getUnenforcedConstraint()));
        Expression[] expressionArray = new Expression[3];
        expressionArray[0] = domainTranslator.toPredicate((TupleDomain<Symbol>)layout.getUnenforcedConstraint().transform(assignments::get));
        expressionArray[1] = ExpressionUtils.filterNonDeterministicConjuncts(predicate);
        expressionArray[2] = decomposedPredicate.getRemainingExpression();
        Expression resultingPredicate = ExpressionUtils.combineConjuncts(expressionArray);
        if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
            return new FilterNode(idAllocator.getNextId(), tableScan, resultingPredicate);
        }
        return tableScan;
    }

    private static class LayoutConstraintEvaluator {
        private final Map<Symbol, ColumnHandle> assignments;
        private final ExpressionInterpreter evaluator;
        private final Set<ColumnHandle> arguments;

        public LayoutConstraintEvaluator(Metadata metadata, SqlParser parser, Session session, TypeProvider types, Map<Symbol, ColumnHandle> assignments, Expression expression) {
            this.assignments = assignments;
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(session, metadata, parser, types, expression, Collections.emptyList(), WarningCollector.NOOP);
            this.evaluator = ExpressionInterpreter.expressionOptimizer(expression, metadata, session, expressionTypes);
            this.arguments = (Set)SymbolsExtractor.extractUnique(expression).stream().map(assignments::get).collect(ImmutableSet.toImmutableSet());
        }

        private boolean isCandidate(Map<ColumnHandle, NullableValue> bindings) {
            if (Sets.intersection(bindings.keySet(), this.arguments).isEmpty()) {
                return true;
            }
            LookupSymbolResolver inputs = new LookupSymbolResolver(this.assignments, bindings);
            Boolean optimized = TryFunction.evaluate(() -> this.evaluator.optimize(inputs), true);
            return !Boolean.FALSE.equals(optimized) && optimized != null && !(optimized instanceof NullLiteral);
        }
    }

    private static final class PickTableLayoutWithoutPredicate
    implements Rule<TableScanNode> {
        private final Metadata metadata;
        private final SqlParser parser;
        private final DomainTranslator domainTranslator;
        private static final Pattern<TableScanNode> PATTERN = Patterns.tableScan();

        private PickTableLayoutWithoutPredicate(Metadata metadata, SqlParser parser, DomainTranslator domainTranslator) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.parser = Objects.requireNonNull(parser, "parser is null");
            this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
        }

        @Override
        public Pattern<TableScanNode> getPattern() {
            return PATTERN;
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isNewOptimizerEnabled(session);
        }

        @Override
        public Rule.Result apply(TableScanNode tableScanNode, Captures captures, Rule.Context context) {
            if (tableScanNode.getLayout().isPresent()) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(PickTableLayout.planTableScan(tableScanNode, (Expression)BooleanLiteral.TRUE_LITERAL, context.getSession(), context.getSymbolAllocator().getTypes(), context.getIdAllocator(), this.metadata, this.parser, this.domainTranslator));
        }
    }

    private static final class PickTableLayoutForPredicate
    implements Rule<FilterNode> {
        private final Metadata metadata;
        private final SqlParser parser;
        private final DomainTranslator domainTranslator;
        private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
        private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));

        private PickTableLayoutForPredicate(Metadata metadata, SqlParser parser, DomainTranslator domainTranslator) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.parser = Objects.requireNonNull(parser, "parser is null");
            this.domainTranslator = Objects.requireNonNull(domainTranslator, "domainTranslator is null");
        }

        @Override
        public Pattern<FilterNode> getPattern() {
            return PATTERN;
        }

        @Override
        public boolean isEnabled(Session session) {
            return SystemSessionProperties.isNewOptimizerEnabled(session);
        }

        @Override
        public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
            PlanNode rewritten;
            TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
            if (this.arePlansSame(filterNode, tableScan, rewritten = PickTableLayout.planTableScan(tableScan, filterNode.getPredicate(), context.getSession(), context.getSymbolAllocator().getTypes(), context.getIdAllocator(), this.metadata, this.parser, this.domainTranslator))) {
                return Rule.Result.empty();
            }
            return Rule.Result.ofPlanNode(rewritten);
        }

        private boolean arePlansSame(FilterNode filter, TableScanNode tableScan, PlanNode rewritten) {
            if (!(rewritten instanceof FilterNode)) {
                return false;
            }
            FilterNode rewrittenFilter = (FilterNode)rewritten;
            if (!Objects.equals(filter.getPredicate(), rewrittenFilter.getPredicate())) {
                return false;
            }
            if (!(rewrittenFilter.getSource() instanceof TableScanNode)) {
                return false;
            }
            TableScanNode rewrittenTableScan = (TableScanNode)rewrittenFilter.getSource();
            if (!tableScan.getLayout().isPresent() && rewrittenTableScan.getLayout().isPresent()) {
                return false;
            }
            return Objects.equals(tableScan.getCurrentConstraint(), rewrittenTableScan.getCurrentConstraint()) && Objects.equals(tableScan.getEnforcedConstraint(), rewrittenTableScan.getEnforcedConstraint());
        }
    }
}

