/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SubPlan {
    private final PlanFragment fragment;
    private final List<SubPlan> children;

    public SubPlan(PlanFragment fragment, List<SubPlan> children) {
        Objects.requireNonNull(fragment, "fragment is null");
        Objects.requireNonNull(children, "children is null");
        this.fragment = fragment;
        this.children = ImmutableList.copyOf(children);
    }

    public PlanFragment getFragment() {
        return this.fragment;
    }

    public List<SubPlan> getChildren() {
        return this.children;
    }

    public List<PlanFragment> getAllFragments() {
        ImmutableList.Builder fragments = ImmutableList.builder();
        fragments.add((Object)this.getFragment());
        for (SubPlan child : this.getChildren()) {
            fragments.addAll(child.getAllFragments());
        }
        return fragments.build();
    }

    public SubPlan withBucketToPartition(Optional<int[]> bucketToPartition) {
        return new SubPlan(this.fragment.withBucketToPartition(bucketToPartition), this.children);
    }

    public void sanityCheck() {
        Multiset remoteSourceIds = (Multiset)this.fragment.getRemoteSourceNodes().stream().map(RemoteSourceNode::getSourceFragmentIds).flatMap(Collection::stream).collect(ImmutableMultiset.toImmutableMultiset());
        Multiset childrenIds = (Multiset)this.children.stream().map(SubPlan::getFragment).map(PlanFragment::getId).collect(ImmutableMultiset.toImmutableMultiset());
        Preconditions.checkState((boolean)childrenIds.containsAll((Collection)remoteSourceIds), (String)"child fragments must include all remote source fragments (%s vs %s)", (Object)remoteSourceIds, (Object)childrenIds);
        for (SubPlan child : this.children) {
            child.sanityCheck();
        }
    }
}

