/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.InsertTableHandle;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.NewTableLayout;
import com.facebook.presto.metadata.PartitioningMetadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SchedulingOrderVisitor;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.SymbolsExtractor;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.sql.planner.sanity.PlanSanityChecker;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.inject.Inject;

public class PlanFragmenter {
    private static final String TOO_MANY_STAGES_MESSAGE = "If the query contains multiple DISTINCTs, please set the 'use_mark_distinct' session property to false. If the query contains multiple CTEs that are referenced more than once, please create temporary table(s) for one or more of the CTEs.";
    private final Metadata metadata;
    private final NodePartitioningManager nodePartitioningManager;
    private final QueryManagerConfig config;
    private final SqlParser sqlParser;

    @Inject
    public PlanFragmenter(Metadata metadata, NodePartitioningManager nodePartitioningManager, QueryManagerConfig queryManagerConfig, SqlParser sqlParser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.config = Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    public SubPlan createSubPlans(Session session, Plan plan, boolean forceSingleNode, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Fragmenter fragmenter = new Fragmenter(session, this.metadata, plan.getStatsAndCosts(), new PlanSanityChecker(forceSingleNode), warningCollector, this.sqlParser, idAllocator, new SymbolAllocator(plan.getTypes().allTypes()));
        FragmentProperties properties = new FragmentProperties(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), plan.getRoot().getOutputSymbols()));
        if (forceSingleNode || SystemSessionProperties.isForceSingleNodeOutput(session)) {
            properties = properties.setSingleNodeDistribution();
        }
        PlanNode root = SimplePlanRewriter.rewriteWith(fragmenter, plan.getRoot(), properties);
        SubPlan subPlan = fragmenter.buildRootFragment(root, properties);
        subPlan = this.reassignPartitioningHandleIfNecessary(session, subPlan);
        subPlan = this.analyzeGroupedExecution(session, subPlan);
        Preconditions.checkState((!SystemSessionProperties.isForceSingleNodeOutput(session) || subPlan.getFragment().getPartitioning().isSingleNode() ? 1 : 0) != 0, (Object)"Root of PlanFragment is not single node");
        this.sanityCheckFragmentedPlan(subPlan, warningCollector, SystemSessionProperties.getQueryMaxStageCount(session), this.config.getStageCountWarningThreshold());
        return subPlan;
    }

    private void sanityCheckFragmentedPlan(SubPlan subPlan, WarningCollector warningCollector, int maxStageCount, int stageCountSoftLimit) {
        subPlan.sanityCheck();
        int fragmentCount = subPlan.getAllFragments().size();
        if (fragmentCount > maxStageCount) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_HAS_TOO_MANY_STAGES, String.format("Number of stages in the query (%s) exceeds the allowed maximum (%s). If the query contains multiple DISTINCTs, please set the 'use_mark_distinct' session property to false. If the query contains multiple CTEs that are referenced more than once, please create temporary table(s) for one or more of the CTEs.", fragmentCount, maxStageCount));
        }
        if (fragmentCount > stageCountSoftLimit) {
            warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.TOO_MANY_STAGES, String.format("Number of stages in the query (%s) exceeds the soft limit (%s). If the query contains multiple DISTINCTs, please set the 'use_mark_distinct' session property to false. If the query contains multiple CTEs that are referenced more than once, please create temporary table(s) for one or more of the CTEs.", fragmentCount, stageCountSoftLimit)));
        }
    }

    private SubPlan analyzeGroupedExecution(Session session, SubPlan subPlan) {
        PlanFragment fragment = subPlan.getFragment();
        GroupedExecutionProperties properties = fragment.getRoot().accept(new GroupedExecutionTagger(session, this.metadata, this.nodePartitioningManager), null);
        if (properties.isSubTreeUseful()) {
            boolean preferDynamic = fragment.getRemoteSourceNodes().stream().allMatch(node -> node.getExchangeType() == ExchangeNode.Type.REPLICATE) && SystemSessionProperties.isDynamicSchduleForGroupedExecution(session);
            BucketNodeMap bucketNodeMap = this.nodePartitioningManager.getBucketNodeMap(session, fragment.getPartitioning(), preferDynamic);
            fragment = bucketNodeMap.isDynamic() ? fragment.withDynamicLifespanScheduleGroupedExecution(properties.getCapableTableScanNodes()) : fragment.withFixedLifespanScheduleGroupedExecution(properties.getCapableTableScanNodes());
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (SubPlan child : subPlan.getChildren()) {
            result.add((Object)this.analyzeGroupedExecution(session, child));
        }
        return new SubPlan(fragment, (List<SubPlan>)result.build());
    }

    private SubPlan reassignPartitioningHandleIfNecessary(Session session, SubPlan subPlan) {
        return this.reassignPartitioningHandleIfNecessaryHelper(session, subPlan, subPlan.getFragment().getPartitioning());
    }

    private SubPlan reassignPartitioningHandleIfNecessaryHelper(Session session, SubPlan subPlan, PartitioningHandle newOutputPartitioningHandle) {
        PlanFragment fragment = subPlan.getFragment();
        PlanNode newRoot = fragment.getRoot();
        if (!fragment.getPartitioning().isSingleNode()) {
            PartitioningHandleReassigner partitioningHandleReassigner = new PartitioningHandleReassigner(fragment.getPartitioning(), this.metadata, session);
            newRoot = SimplePlanRewriter.rewriteWith(partitioningHandleReassigner, newRoot);
        }
        PartitioningScheme outputPartitioningScheme = fragment.getPartitioningScheme();
        Partitioning newOutputPartitioning = outputPartitioningScheme.getPartitioning();
        if (outputPartitioningScheme.getPartitioning().getHandle().getConnectorId().isPresent()) {
            newOutputPartitioning = newOutputPartitioning.withAlternativePartitiongingHandle(newOutputPartitioningHandle);
        }
        PlanFragment newFragment = new PlanFragment(fragment.getId(), newRoot, fragment.getSymbols(), fragment.getPartitioning(), fragment.getPartitionedSources(), new PartitioningScheme(newOutputPartitioning, outputPartitioningScheme.getOutputLayout(), outputPartitioningScheme.getHashColumn(), outputPartitioningScheme.isReplicateNullsAndAny(), outputPartitioningScheme.getBucketToPartition()), fragment.getStageExecutionDescriptor(), fragment.getStatsAndCosts(), fragment.getJsonRepresentation());
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        for (SubPlan child : subPlan.getChildren()) {
            childrenBuilder.add((Object)this.reassignPartitioningHandleIfNecessaryHelper(session, child, fragment.getPartitioning()));
        }
        return new SubPlan(newFragment, (List<SubPlan>)childrenBuilder.build());
    }

    private static class PartitioningSymbolAssignments {
        private final List<Symbol> symbols;
        private final Map<Symbol, Expression> constants;

        private PartitioningSymbolAssignments(List<Symbol> symbols, Map<Symbol, Expression> constants) {
            this.symbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(symbols, "symbols is null"));
            this.constants = ImmutableMap.copyOf(Objects.requireNonNull(constants, "constants is null"));
            Preconditions.checkArgument((boolean)ImmutableSet.copyOf(symbols).containsAll(constants.keySet()), (Object)"partitioningSymbols list must contain all partitioning symbols including constants");
        }

        public List<Symbol> getSymbols() {
            return this.symbols;
        }

        public Map<Symbol, Expression> getConstants() {
            return this.constants;
        }
    }

    private static final class PartitioningHandleReassigner
    extends SimplePlanRewriter<Void> {
        private final PartitioningHandle fragmentPartitioningHandle;
        private final Metadata metadata;
        private final Session session;

        public PartitioningHandleReassigner(PartitioningHandle fragmentPartitioningHandle, Metadata metadata, Session session) {
            this.fragmentPartitioningHandle = fragmentPartitioningHandle;
            this.metadata = metadata;
            this.session = session;
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PartitioningHandle partitioning = node.getLayout().map(layout -> this.metadata.getLayout(this.session, (TableLayoutHandle)layout)).flatMap(TableLayout::getTablePartitioning).map(TableLayout.TablePartitioning::getPartitioningHandle).orElse(SystemPartitioningHandle.SOURCE_DISTRIBUTION);
            if (partitioning.equals(this.fragmentPartitioningHandle)) {
                return node;
            }
            TableLayoutHandle newTableLayoutHandle = this.metadata.getAlternativeLayoutHandle(this.session, node.getLayout().get(), this.fragmentPartitioningHandle);
            return new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), Optional.of(newTableLayoutHandle), node.getCurrentConstraint(), node.getEnforcedConstraint());
        }
    }

    private static class GroupedExecutionProperties {
        private final boolean currentNodeCapable;
        private final boolean subTreeUseful;
        private final List<PlanNodeId> capableTableScanNodes;

        public GroupedExecutionProperties(boolean currentNodeCapable, boolean subTreeUseful, List<PlanNodeId> capableTableScanNodes) {
            this.currentNodeCapable = currentNodeCapable;
            this.subTreeUseful = subTreeUseful;
            this.capableTableScanNodes = ImmutableList.copyOf((Collection)Objects.requireNonNull(capableTableScanNodes, "capableTableScanNodes is null"));
            Preconditions.checkArgument((!subTreeUseful || currentNodeCapable ? 1 : 0) != 0);
            Preconditions.checkArgument((currentNodeCapable == !capableTableScanNodes.isEmpty() ? 1 : 0) != 0);
        }

        public static GroupedExecutionProperties notCapable() {
            return new GroupedExecutionProperties(false, false, (List<PlanNodeId>)ImmutableList.of());
        }

        public boolean isCurrentNodeCapable() {
            return this.currentNodeCapable;
        }

        public boolean isSubTreeUseful() {
            return this.subTreeUseful;
        }

        public List<PlanNodeId> getCapableTableScanNodes() {
            return this.capableTableScanNodes;
        }
    }

    private static class GroupedExecutionTagger
    extends PlanVisitor<GroupedExecutionProperties, Void> {
        private final Session session;
        private final Metadata metadata;
        private final NodePartitioningManager nodePartitioningManager;
        private final boolean groupedExecutionForAggregation;

        public GroupedExecutionTagger(Session session, Metadata metadata, NodePartitioningManager nodePartitioningManager) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
            this.groupedExecutionForAggregation = SystemSessionProperties.isGroupedExecutionForAggregationEnabled(session);
        }

        @Override
        protected GroupedExecutionProperties visitPlan(PlanNode node, Void context) {
            if (node.getSources().isEmpty()) {
                return GroupedExecutionProperties.notCapable();
            }
            return this.processChildren(node);
        }

        @Override
        public GroupedExecutionProperties visitJoin(JoinNode node, Void context) {
            GroupedExecutionProperties left = node.getLeft().accept(this, null);
            GroupedExecutionProperties right = node.getRight().accept(this, null);
            if (!node.getDistributionType().isPresent()) {
                return GroupedExecutionProperties.notCapable();
            }
            if (!(node.getType() != JoinNode.Type.RIGHT && node.getType() != JoinNode.Type.FULL || right.currentNodeCapable)) {
                return GroupedExecutionProperties.notCapable();
            }
            switch (node.getDistributionType().get()) {
                case REPLICATED: {
                    Preconditions.checkState((!right.currentNodeCapable ? 1 : 0) != 0);
                    return left;
                }
                case PARTITIONED: {
                    if (left.currentNodeCapable && right.currentNodeCapable) {
                        return new GroupedExecutionProperties(true, true, (List<PlanNodeId>)ImmutableList.builder().addAll((Iterable)left.capableTableScanNodes).addAll((Iterable)right.capableTableScanNodes).build());
                    }
                    return left;
                }
            }
            throw new UnsupportedOperationException("Unknown distribution type: " + node.getDistributionType());
        }

        @Override
        public GroupedExecutionProperties visitAggregation(AggregationNode node, Void context) {
            GroupedExecutionProperties properties = node.getSource().accept(this, null);
            if (this.groupedExecutionForAggregation && properties.isCurrentNodeCapable()) {
                switch (node.getStep()) {
                    case SINGLE: 
                    case FINAL: {
                        return new GroupedExecutionProperties(true, true, properties.capableTableScanNodes);
                    }
                    case PARTIAL: 
                    case INTERMEDIATE: {
                        return properties;
                    }
                }
            }
            return GroupedExecutionProperties.notCapable();
        }

        @Override
        public GroupedExecutionProperties visitWindow(WindowNode node, Void context) {
            return this.processWindowFunction(node);
        }

        @Override
        public GroupedExecutionProperties visitRowNumber(RowNumberNode node, Void context) {
            return this.processWindowFunction(node);
        }

        @Override
        public GroupedExecutionProperties visitTopNRowNumber(TopNRowNumberNode node, Void context) {
            return this.processWindowFunction(node);
        }

        private GroupedExecutionProperties processWindowFunction(PlanNode node) {
            GroupedExecutionProperties properties = ((PlanNode)Iterables.getOnlyElement(node.getSources())).accept(this, null);
            if (this.groupedExecutionForAggregation && properties.isCurrentNodeCapable()) {
                return new GroupedExecutionProperties(true, true, properties.capableTableScanNodes);
            }
            return GroupedExecutionProperties.notCapable();
        }

        @Override
        public GroupedExecutionProperties visitTableScan(TableScanNode node, Void context) {
            Optional<TableLayout.TablePartitioning> tablePartitioning = this.metadata.getLayout(this.session, node.getLayout().get()).getTablePartitioning();
            if (!tablePartitioning.isPresent()) {
                return GroupedExecutionProperties.notCapable();
            }
            List<ConnectorPartitionHandle> partitionHandles = this.nodePartitioningManager.listPartitionHandles(this.session, tablePartitioning.get().getPartitioningHandle());
            if (ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED).equals(partitionHandles)) {
                return new GroupedExecutionProperties(false, false, (List<PlanNodeId>)ImmutableList.of());
            }
            return new GroupedExecutionProperties(true, false, (List<PlanNodeId>)ImmutableList.of((Object)node.getId()));
        }

        private GroupedExecutionProperties processChildren(PlanNode node) {
            boolean anyUseful = false;
            ImmutableList.Builder capableTableScanNodes = ImmutableList.builder();
            for (PlanNode source : node.getSources()) {
                GroupedExecutionProperties properties = source.accept(this, null);
                if (!properties.isCurrentNodeCapable()) {
                    return GroupedExecutionProperties.notCapable();
                }
                anyUseful |= properties.isSubTreeUseful();
                capableTableScanNodes.addAll((Iterable)properties.capableTableScanNodes);
            }
            return new GroupedExecutionProperties(true, anyUseful, (List<PlanNodeId>)capableTableScanNodes.build());
        }
    }

    private static class FragmentProperties {
        private final List<SubPlan> children = new ArrayList<SubPlan>();
        private final PartitioningScheme partitioningScheme;
        private Optional<PartitioningHandle> partitioningHandle = Optional.empty();
        private final Set<PlanNodeId> partitionedSources = new HashSet<PlanNodeId>();

        public FragmentProperties(PartitioningScheme partitioningScheme) {
            this.partitioningScheme = partitioningScheme;
        }

        public List<SubPlan> getChildren() {
            return this.children;
        }

        public FragmentProperties setSingleNodeDistribution() {
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isSingleNode()) {
                return this;
            }
            Preconditions.checkState((!this.partitioningHandle.isPresent() ? 1 : 0) != 0, (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object)SystemPartitioningHandle.SINGLE_DISTRIBUTION, this.partitioningHandle);
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.SINGLE_DISTRIBUTION);
            return this;
        }

        public FragmentProperties setDistribution(PartitioningHandle distribution, Metadata metadata, Session session) {
            if (!this.partitioningHandle.isPresent()) {
                this.partitioningHandle = Optional.of(distribution);
                return this;
            }
            PartitioningHandle currentPartitioning = this.partitioningHandle.get();
            if (this.isCompatibleSystemPartitioning(distribution)) {
                return this;
            }
            if (currentPartitioning.equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
                this.partitioningHandle = Optional.of(distribution);
                return this;
            }
            if (currentPartitioning.isSingleNode()) {
                return this;
            }
            if (currentPartitioning.equals(distribution)) {
                return this;
            }
            Optional<PartitioningHandle> commonPartitioning = metadata.getCommonPartitioning(session, currentPartitioning, distribution);
            if (commonPartitioning.isPresent()) {
                this.partitioningHandle = commonPartitioning;
                return this;
            }
            throw new IllegalStateException(String.format("Cannot set distribution to %s. Already set to %s", distribution, this.partitioningHandle));
        }

        private boolean isCompatibleSystemPartitioning(PartitioningHandle distribution) {
            ConnectorPartitioningHandle currentHandle = this.partitioningHandle.get().getConnectorHandle();
            ConnectorPartitioningHandle distributionHandle = distribution.getConnectorHandle();
            if (currentHandle instanceof SystemPartitioningHandle && distributionHandle instanceof SystemPartitioningHandle) {
                return ((SystemPartitioningHandle)currentHandle).getPartitioning() == ((SystemPartitioningHandle)distributionHandle).getPartitioning();
            }
            return false;
        }

        public FragmentProperties setCoordinatorOnlyDistribution() {
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isCoordinatorOnly()) {
                return this;
            }
            Preconditions.checkState((!this.partitioningHandle.isPresent() || this.partitioningHandle.get().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) ? 1 : 0) != 0, (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object)SystemPartitioningHandle.COORDINATOR_DISTRIBUTION, this.partitioningHandle);
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION);
            return this;
        }

        public FragmentProperties addSourceDistribution(PlanNodeId source, PartitioningHandle distribution, Metadata metadata, Session session) {
            Objects.requireNonNull(source, "source is null");
            Objects.requireNonNull(distribution, "distribution is null");
            this.partitionedSources.add(source);
            return this.setDistribution(distribution, metadata, session);
        }

        public FragmentProperties addChildren(List<SubPlan> children) {
            this.children.addAll(children);
            return this;
        }

        public PartitioningScheme getPartitioningScheme() {
            return this.partitioningScheme;
        }

        public PartitioningHandle getPartitioningHandle() {
            return this.partitioningHandle.get();
        }

        public Set<PlanNodeId> getPartitionedSources() {
            return this.partitionedSources;
        }
    }

    private static class Fragmenter
    extends SimplePlanRewriter<FragmentProperties> {
        private static final int ROOT_FRAGMENT_ID = 0;
        private final Session session;
        private final Metadata metadata;
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final StatsAndCosts statsAndCosts;
        private final PlanSanityChecker planSanityChecker;
        private final WarningCollector warningCollector;
        private final SqlParser sqlParser;
        private final LiteralEncoder literalEncoder;
        private int nextFragmentId = 1;

        public Fragmenter(Session session, Metadata metadata, StatsAndCosts statsAndCosts, PlanSanityChecker planSanityChecker, WarningCollector warningCollector, SqlParser sqlParser, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.statsAndCosts = Objects.requireNonNull(statsAndCosts, "statsAndCosts is null");
            this.planSanityChecker = Objects.requireNonNull(planSanityChecker, "planSanityChecker is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
            this.literalEncoder = new LiteralEncoder(metadata.getBlockEncodingSerde());
        }

        public SubPlan buildRootFragment(PlanNode root, FragmentProperties properties) {
            return this.buildFragment(root, properties, new PlanFragmentId(String.valueOf(0)));
        }

        private PlanFragmentId nextFragmentId() {
            return new PlanFragmentId(String.valueOf(this.nextFragmentId++));
        }

        private SubPlan buildFragment(PlanNode root, FragmentProperties properties, PlanFragmentId fragmentId) {
            List<PlanNodeId> schedulingOrder = SchedulingOrderVisitor.scheduleOrder(root);
            Preconditions.checkArgument((boolean)properties.getPartitionedSources().equals(ImmutableSet.copyOf(schedulingOrder)), (String)"Expected scheduling order (%s) to contain an entry for all partitioned sources (%s)", schedulingOrder, properties.getPartitionedSources());
            Map fragmentSymbolTypes = Maps.filterKeys(this.symbolAllocator.getTypes().allTypes(), (Predicate)Predicates.in(SymbolsExtractor.extractOutputSymbols(root)));
            this.planSanityChecker.validatePlanFragment(root, this.session, this.metadata, this.sqlParser, TypeProvider.viewOf(fragmentSymbolTypes), this.warningCollector);
            PlanFragment fragment = new PlanFragment(fragmentId, root, fragmentSymbolTypes, properties.getPartitioningHandle(), schedulingOrder, properties.getPartitioningScheme(), StageExecutionDescriptor.ungroupedExecution(), this.statsAndCosts.getForSubplan(root), Optional.of(PlanPrinter.jsonFragmentPlan(root, fragmentSymbolTypes, this.metadata.getFunctionManager(), this.session)));
            return new SubPlan(fragment, properties.getChildren());
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            if (SystemSessionProperties.isForceSingleNodeOutput(this.session)) {
                context.get().setSingleNodeDistribution();
            }
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitStatisticsWriterNode(StatisticsWriterNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitMetadataDelete(MetadataDeleteNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            PartitioningHandle partitioning = node.getLayout().map(layout -> this.metadata.getLayout(this.session, (TableLayoutHandle)layout)).flatMap(TableLayout::getTablePartitioning).map(TableLayout.TablePartitioning::getPartitioningHandle).orElse(SystemPartitioningHandle.SOURCE_DISTRIBUTION);
            context.get().addSourceDistribution(node.getId(), partitioning, this.metadata, this.session);
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableWriter(TableWriterNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            if (node.getPartitioningScheme().isPresent()) {
                context.get().setDistribution(node.getPartitioningScheme().get().getPartitioning().getHandle(), this.metadata, this.session);
            }
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSingleNodeDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            switch (exchange.getScope()) {
                case LOCAL: {
                    return context.defaultRewrite(exchange, context.get());
                }
                case REMOTE_STREAMING: {
                    return this.createRemoteStreamingExchange(exchange, context);
                }
                case REMOTE_MATERIALIZED: {
                    return this.createRemoteMaterializedExchange(exchange, context);
                }
            }
            throw new IllegalArgumentException("Unexpected exchange scope: " + (Object)((Object)exchange.getScope()));
        }

        private PlanNode createRemoteStreamingExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            Preconditions.checkArgument((exchange.getScope() == ExchangeNode.Scope.REMOTE_STREAMING ? 1 : 0) != 0, (String)"Unexpected exchange scope: %s", (Object)((Object)exchange.getScope()));
            PartitioningScheme partitioningScheme = exchange.getPartitioningScheme();
            if (exchange.getType() == ExchangeNode.Type.GATHER) {
                context.get().setSingleNodeDistribution();
            } else if (exchange.getType() == ExchangeNode.Type.REPARTITION) {
                context.get().setDistribution(partitioningScheme.getPartitioning().getHandle(), this.metadata, this.session);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int sourceIndex = 0; sourceIndex < exchange.getSources().size(); ++sourceIndex) {
                FragmentProperties childProperties = new FragmentProperties(partitioningScheme.translateOutputLayout(exchange.getInputs().get(sourceIndex)));
                builder.add((Object)this.buildSubPlan(exchange.getSources().get(sourceIndex), childProperties, context));
            }
            ImmutableList children = builder.build();
            context.get().addChildren((List<SubPlan>)children);
            List childrenIds = (List)children.stream().map(SubPlan::getFragment).map(PlanFragment::getId).collect(ImmutableList.toImmutableList());
            return new RemoteSourceNode(exchange.getId(), childrenIds, exchange.getOutputSymbols(), exchange.getOrderingScheme(), exchange.getType());
        }

        private PlanNode createRemoteMaterializedExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            Preconditions.checkArgument((exchange.getType() == ExchangeNode.Type.REPARTITION ? 1 : 0) != 0, (String)"Unexpected exchange type: %s", (Object)((Object)exchange.getType()));
            Preconditions.checkArgument((exchange.getScope() == ExchangeNode.Scope.REMOTE_MATERIALIZED ? 1 : 0) != 0, (String)"Unexpected exchange scope: %s", (Object)((Object)exchange.getScope()));
            PartitioningScheme partitioningScheme = exchange.getPartitioningScheme();
            Preconditions.checkArgument((!partitioningScheme.getHashColumn().isPresent() ? 1 : 0) != 0, (Object)"precomputed hashes are not supported in materializing exchanges");
            PartitioningHandle partitioningHandle = partitioningScheme.getPartitioning().getHandle();
            ConnectorId connectorId = partitioningHandle.getConnectorId().orElseThrow(() -> new IllegalArgumentException("Unsupported partitioning handle: " + partitioningHandle));
            Partitioning partitioning = partitioningScheme.getPartitioning();
            PartitioningSymbolAssignments partitioningSymbolAssignments = this.assignPartitioningSymbols(partitioning);
            Map<Symbol, ColumnMetadata> symbolToColumnMap = this.assignTemporaryTableColumnNames(exchange.getOutputSymbols(), partitioningSymbolAssignments.getConstants().keySet());
            List<Symbol> partitioningSymbols = partitioningSymbolAssignments.getSymbols();
            List partitionColumns = (List)partitioningSymbols.stream().map(symbol -> ((ColumnMetadata)symbolToColumnMap.get(symbol)).getName()).collect(ImmutableList.toImmutableList());
            PartitioningMetadata partitioningMetadata = new PartitioningMetadata(partitioningHandle, partitionColumns);
            TableHandle temporaryTableHandle = this.metadata.createTemporaryTable(this.session, connectorId.getCatalogName(), (List<ColumnMetadata>)ImmutableList.copyOf(symbolToColumnMap.values()), Optional.of(partitioningMetadata));
            TableScanNode scan = this.createTemporaryTableScan(temporaryTableHandle, exchange.getOutputSymbols(), symbolToColumnMap, partitioningMetadata);
            Preconditions.checkArgument((!exchange.getPartitioningScheme().isReplicateNullsAndAny() ? 1 : 0) != 0, (Object)"materialized remote exchange is not supported when replicateNullsAndAny is needed");
            TableFinishNode write = this.createTemporaryTableWrite(temporaryTableHandle, symbolToColumnMap, exchange.getOutputSymbols(), exchange.getInputs(), exchange.getSources(), partitioningSymbolAssignments.getConstants(), partitioningMetadata);
            FragmentProperties writeProperties = new FragmentProperties(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), write.getOutputSymbols()));
            writeProperties.setCoordinatorOnlyDistribution();
            ImmutableList children = ImmutableList.of((Object)this.buildSubPlan(write, writeProperties, context));
            context.get().addChildren((List<SubPlan>)children);
            return this.visitTableScan(scan, context);
        }

        private PartitioningSymbolAssignments assignPartitioningSymbols(Partitioning partitioning) {
            ImmutableList.Builder symbols = ImmutableList.builder();
            ImmutableMap.Builder constants = ImmutableMap.builder();
            for (Partitioning.ArgumentBinding argumentBinding : partitioning.getArguments()) {
                Symbol symbol;
                if (argumentBinding.isConstant()) {
                    NullableValue constant = argumentBinding.getConstant();
                    Expression expression = this.literalEncoder.toExpression(constant.getValue(), constant.getType());
                    symbol = this.symbolAllocator.newSymbol(expression, constant.getType());
                    constants.put((Object)symbol, (Object)expression);
                } else {
                    symbol = argumentBinding.getColumn();
                }
                symbols.add((Object)symbol);
            }
            return new PartitioningSymbolAssignments((List)symbols.build(), (Map)constants.build());
        }

        private Map<Symbol, ColumnMetadata> assignTemporaryTableColumnNames(Collection<Symbol> outputSymbols, Collection<Symbol> constantPartitioningSymbols) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            int column = 0;
            for (Symbol outputSymbol : Iterables.concat(outputSymbols, constantPartitioningSymbols)) {
                String columnName = String.format("_c%d_%s", column, outputSymbol.getName());
                result.put((Object)outputSymbol, (Object)new ColumnMetadata(columnName, this.symbolAllocator.getTypes().get(outputSymbol)));
                ++column;
            }
            return result.build();
        }

        private TableScanNode createTemporaryTableScan(TableHandle tableHandle, List<Symbol> outputSymbols, Map<Symbol, ColumnMetadata> symbolToColumnMap, PartitioningMetadata expectedPartitioningMetadata) {
            Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, tableHandle);
            Map outputColumns = (Map)outputSymbols.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), symbolToColumnMap::get));
            Set outputColumnHandles = (Set)outputColumns.values().stream().map(ColumnMetadata::getName).map(columnHandles::get).collect(ImmutableSet.toImmutableSet());
            List<TableLayoutResult> layouts = this.metadata.getLayouts(this.session, tableHandle, (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.of(outputColumnHandles));
            Preconditions.checkArgument((layouts.size() == 1 ? 1 : 0) != 0, (Object)"temporary table is expected to have exactly one layout");
            TableLayoutResult selectedLayout = (TableLayoutResult)Iterables.getOnlyElement(layouts);
            Verify.verify((boolean)selectedLayout.getUnenforcedConstraint().equals((Object)TupleDomain.all()), (String)"temporary table layout shouldn't enforce any constraints", (Object[])new Object[0]);
            Verify.verify((!selectedLayout.getLayout().getColumns().isPresent() ? 1 : 0) != 0, (String)"temporary table layout must provide all the columns", (Object[])new Object[0]);
            TableLayout.TablePartitioning expectedPartitioning = new TableLayout.TablePartitioning(expectedPartitioningMetadata.getPartitioningHandle(), (List)expectedPartitioningMetadata.getPartitionColumns().stream().map(columnHandles::get).collect(ImmutableList.toImmutableList()));
            Verify.verify((boolean)selectedLayout.getLayout().getTablePartitioning().equals(Optional.of(expectedPartitioning)), (String)"invalid temporary table partitioning", (Object[])new Object[0]);
            TableLayoutHandle layoutHandle = selectedLayout.getLayout().getHandle();
            Map assignments = (Map)outputSymbols.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), symbol -> (ColumnHandle)columnHandles.get(((ColumnMetadata)outputColumns.get(symbol)).getName())));
            return new TableScanNode(this.idAllocator.getNextId(), tableHandle, outputSymbols, assignments, Optional.of(layoutHandle), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all());
        }

        private TableFinishNode createTemporaryTableWrite(TableHandle tableHandle, Map<Symbol, ColumnMetadata> symbolToColumnMap, List<Symbol> outputs, List<List<Symbol>> inputs, List<PlanNode> sources, Map<Symbol, Expression> constantExpressions, PartitioningMetadata partitioningMetadata) {
            if (!constantExpressions.isEmpty()) {
                ImmutableList constantSymbols = ImmutableList.copyOf(constantExpressions.keySet());
                outputs = ImmutableList.builder().addAll(outputs).addAll((Iterable)constantSymbols).build();
                inputs = (List)inputs.stream().map(arg_0 -> Fragmenter.lambda$createTemporaryTableWrite$4((List)constantSymbols, arg_0)).collect(ImmutableList.toImmutableList());
                sources = (List)sources.stream().map(arg_0 -> this.lambda$createTemporaryTableWrite$6((List)constantSymbols, constantExpressions, arg_0)).collect(ImmutableList.toImmutableList());
            }
            NewTableLayout insertLayout = this.metadata.getInsertLayout(this.session, tableHandle).orElseThrow(() -> new IllegalArgumentException("insertLayout for the temporary table must be present"));
            PartitioningHandle partitioningHandle = partitioningMetadata.getPartitioningHandle();
            List<String> partitionColumns = partitioningMetadata.getPartitionColumns();
            ConnectorNewTableLayout expectedNewTableLayout = new ConnectorNewTableLayout(partitioningHandle.getConnectorHandle(), partitionColumns);
            Verify.verify((boolean)insertLayout.getLayout().equals((Object)expectedNewTableLayout), (String)"unexpected new table layout", (Object[])new Object[0]);
            Map columnNameToSymbol = (Map)symbolToColumnMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((ColumnMetadata)entry.getValue()).getName(), Map.Entry::getKey));
            List partitioningSymbols = (List)partitionColumns.stream().map(columnNameToSymbol::get).collect(ImmutableList.toImmutableList());
            InsertTableHandle insertTableHandle = this.metadata.beginInsert(this.session, tableHandle);
            List outputColumnNames = (List)outputs.stream().map(symbolToColumnMap::get).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
            SchemaTableName temporaryTableName = this.metadata.getTableMetadata(this.session, tableHandle).getTable();
            TableWriterNode.InsertHandle insertHandle = new TableWriterNode.InsertHandle(insertTableHandle, new SchemaTableName(temporaryTableName.getSchemaName(), temporaryTableName.getTableName()));
            return new TableFinishNode(this.idAllocator.getNextId(), ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.REMOTE_STREAMING, new TableWriterNode(this.idAllocator.getNextId(), ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.REPARTITION, ExchangeNode.Scope.REMOTE_STREAMING, new PartitioningScheme(Partitioning.create(partitioningHandle, partitioningSymbols), (List<Symbol>)outputs, Optional.empty(), false, Optional.empty()), sources, inputs, Optional.empty())), insertHandle, this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY), (List<Symbol>)outputs, outputColumnNames, Optional.of(new PartitioningScheme(Partitioning.create(partitioningHandle, partitioningSymbols), (List<Symbol>)outputs, Optional.empty(), false, Optional.empty())), Optional.empty(), Optional.empty()))), insertHandle, this.symbolAllocator.newSymbol("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty());
        }

        private SubPlan buildSubPlan(PlanNode node, FragmentProperties properties, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            PlanFragmentId planFragmentId = this.nextFragmentId();
            PlanNode child = context.rewrite(node, properties);
            return this.buildFragment(child, properties, planFragmentId);
        }

        private /* synthetic */ ProjectNode lambda$createTemporaryTableWrite$6(List constantSymbols, Map constantExpressions, PlanNode source) {
            Assignments.Builder assignments = Assignments.builder();
            assignments.putIdentities(source.getOutputSymbols());
            constantSymbols.forEach(symbol -> assignments.put((Symbol)symbol, (Expression)constantExpressions.get(symbol)));
            return new ProjectNode(this.idAllocator.getNextId(), source, assignments.build());
        }

        private static /* synthetic */ ImmutableList lambda$createTemporaryTableWrite$4(List constantSymbols, List input) {
            return ImmutableList.builder().addAll((Iterable)input).addAll((Iterable)constantSymbols).build();
        }
    }
}

