/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import java.util.List;

public final class FragmentTableScanCounter {
    private FragmentTableScanCounter() {
    }

    public static int countSources(List<PlanNode> nodes) {
        int count = 0;
        for (PlanNode node : nodes) {
            count += node.accept(new Visitor(), null).intValue();
        }
        return count;
    }

    public static boolean hasMultipleSources(PlanNode ... nodes) {
        int count = 0;
        for (PlanNode node : nodes) {
            count += node.accept(new Visitor(), null).intValue();
        }
        return count > 1;
    }

    private static class Visitor
    extends PlanVisitor<Integer, Void> {
        private Visitor() {
        }

        @Override
        public Integer visitTableScan(TableScanNode node, Void context) {
            return 1;
        }

        @Override
        public Integer visitExchange(ExchangeNode node, Void context) {
            if (node.getScope().isRemote()) {
                return 0;
            }
            return this.visitPlan((PlanNode)node, context);
        }

        @Override
        protected Integer visitPlan(PlanNode node, Void context) {
            int count = 0;
            for (PlanNode source : node.getSources()) {
                count += source.accept(this, context).intValue();
            }
            return count;
        }
    }
}

