/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.metadata.CastType;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import java.util.List;
import java.util.Optional;

public class NullIfCodeGenerator
implements SpecialFormBytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        Scope scope = generatorContext.getScope();
        RowExpression first = arguments.get(0);
        RowExpression second = arguments.get(1);
        LabelNode notMatch = new LabelNode("notMatch");
        Variable firstValue = scope.createTempVariable(first.getType().getJavaType());
        BytecodeBlock block = new BytecodeBlock().comment("check if first arg is null").append(generatorContext.generate(first, Optional.empty())).append(BytecodeUtils.ifWasNullPopAndGoto(scope, notMatch, Void.TYPE, new Class[0])).dup(first.getType().getJavaType()).putVariable(firstValue);
        Type firstType = first.getType();
        Type secondType = second.getType();
        FunctionHandle equalFunction = generatorContext.getFunctionManager().resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes(firstType, secondType));
        ScalarFunctionImplementation equalsFunction = generatorContext.getFunctionManager().getScalarFunctionImplementation(equalFunction);
        BytecodeNode equalsCall = generatorContext.generateCall(OperatorType.EQUAL.name(), equalsFunction, (List<BytecodeNode>)ImmutableList.of((Object)NullIfCodeGenerator.cast(generatorContext, (BytecodeNode)firstValue, firstType, (TypeSignature)equalFunction.getSignature().getArgumentTypes().get(0)), (Object)NullIfCodeGenerator.cast(generatorContext, generatorContext.generate(second, Optional.empty()), secondType, (TypeSignature)equalFunction.getSignature().getArgumentTypes().get(1))));
        BytecodeBlock conditionBlock = new BytecodeBlock().append(equalsCall).append(BytecodeUtils.ifWasNullClearPopAndGoto(scope, notMatch, Void.TYPE, Boolean.TYPE));
        BytecodeBlock trueBlock = new BytecodeBlock().append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantTrue())).pop(first.getType().getJavaType()).pushJavaDefault(first.getType().getJavaType());
        block.append((BytecodeNode)new IfStatement().condition((BytecodeNode)conditionBlock).ifTrue((BytecodeNode)trueBlock).ifFalse((BytecodeNode)notMatch));
        outputBlockVariable.ifPresent(output -> block.append(SpecialFormBytecodeGenerator.generateWrite(generatorContext, returnType, output)));
        return block;
    }

    private static BytecodeNode cast(BytecodeGeneratorContext generatorContext, BytecodeNode argument, Type actualType, TypeSignature requiredType) {
        if (actualType.getTypeSignature().equals((Object)requiredType)) {
            return argument;
        }
        FunctionHandle functionHandle = generatorContext.getFunctionManager().lookupCast(CastType.CAST, actualType.getTypeSignature(), requiredType);
        return generatorContext.generateCall(OperatorType.CAST.name(), generatorContext.getFunctionManager().getScalarFunctionImplementation(functionHandle), (List<BytecodeNode>)ImmutableList.of((Object)argument));
    }
}

