/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.google.common.collect.Lists;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class CoalesceCodeGenerator
implements SpecialFormBytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        ArrayList<BytecodeNode> operands = new ArrayList<BytecodeNode>();
        for (RowExpression expression : arguments) {
            operands.add(generatorContext.generate(expression, Optional.empty()));
        }
        Variable wasNull = generatorContext.wasNull();
        BytecodeBlock nullValue = new BytecodeBlock().append((BytecodeNode)wasNull.set(BytecodeExpressions.constantTrue())).pushJavaDefault(returnType.getJavaType());
        for (BytecodeNode operand : Lists.reverse(operands)) {
            IfStatement ifStatement = new IfStatement();
            ifStatement.condition().append(operand).append((BytecodeNode)wasNull);
            ifStatement.ifTrue().pop(returnType.getJavaType()).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse())).append((BytecodeNode)nullValue);
            nullValue = ifStatement;
        }
        BytecodeBlock block = new BytecodeBlock().append((BytecodeNode)nullValue);
        outputBlockVariable.ifPresent(output -> block.append(SpecialFormBytecodeGenerator.generateWrite(generatorContext, returnType, output)));
        return block;
    }
}

