/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BindCodeGenerator
implements SpecialFormBytecodeGenerator {
    private final Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap;
    private final Class lambdaInterface;

    public BindCodeGenerator(Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap, Class lambdaInterface) {
        this.compiledLambdaMap = compiledLambdaMap;
        this.lambdaInterface = lambdaInterface;
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        Preconditions.checkArgument((!outputBlockVariable.isPresent() ? 1 : 0) != 0);
        int numCaptures = arguments.size() - 1;
        LambdaDefinitionExpression lambda = (LambdaDefinitionExpression)arguments.get(numCaptures);
        Preconditions.checkState((boolean)this.compiledLambdaMap.containsKey(lambda), (Object)"lambda expressions map does not contain this lambda definition");
        LambdaBytecodeGenerator.CompiledLambda compiledLambda = this.compiledLambdaMap.get(lambda);
        return LambdaBytecodeGenerator.generateLambda(context, arguments.subList(0, numCaptures), compiledLambda, this.lambdaInterface);
    }
}

