/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.smile;

import com.facebook.presto.server.smile.SmileCodec;
import com.facebook.presto.server.smile.SmileCodecProvider;
import com.google.common.annotations.Beta;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Provider;

@Beta
public class SmileCodecBinder {
    private final Binder binder;

    public static SmileCodecBinder smileCodecBinder(Binder binder) {
        return new SmileCodecBinder(binder);
    }

    private SmileCodecBinder(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null").skipSources(new Class[]{this.getClass()});
    }

    public void bindSmileCodec(Class<?> type) {
        Objects.requireNonNull(type, "type is null");
        this.binder.bind(this.getSmileCodecKey(type)).toProvider((Provider)new SmileCodecProvider(type)).in(Scopes.SINGLETON);
    }

    public void bindSmileCodec(TypeLiteral<?> type) {
        Objects.requireNonNull(type, "type is null");
        this.binder.bind(this.getSmileCodecKey(type.getType())).toProvider((Provider)new SmileCodecProvider(type.getType())).in(Scopes.SINGLETON);
    }

    public void bindListSmileCodec(Class<?> type) {
        Objects.requireNonNull(type, "type is null");
        MoreTypes.ParameterizedTypeImpl listType = new MoreTypes.ParameterizedTypeImpl(null, List.class, new Type[]{type});
        this.binder.bind(this.getSmileCodecKey((Type)listType)).toProvider((Provider)new SmileCodecProvider((Type)listType)).in(Scopes.SINGLETON);
    }

    public void bindListSmileCodec(SmileCodec<?> type) {
        Objects.requireNonNull(type, "type is null");
        MoreTypes.ParameterizedTypeImpl listType = new MoreTypes.ParameterizedTypeImpl(null, List.class, new Type[]{type.getType()});
        this.binder.bind(this.getSmileCodecKey((Type)listType)).toProvider((Provider)new SmileCodecProvider((Type)listType)).in(Scopes.SINGLETON);
    }

    public void bindMapSmileCodec(Class<?> keyType, Class<?> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        MoreTypes.ParameterizedTypeImpl mapType = new MoreTypes.ParameterizedTypeImpl(null, Map.class, new Type[]{keyType, valueType});
        this.binder.bind(this.getSmileCodecKey((Type)mapType)).toProvider((Provider)new SmileCodecProvider((Type)mapType)).in(Scopes.SINGLETON);
    }

    public void bindMapSmileCodec(Class<?> keyType, SmileCodec<?> valueType) {
        Objects.requireNonNull(keyType, "keyType is null");
        Objects.requireNonNull(valueType, "valueType is null");
        MoreTypes.ParameterizedTypeImpl mapType = new MoreTypes.ParameterizedTypeImpl(null, Map.class, new Type[]{keyType, valueType.getType()});
        this.binder.bind(this.getSmileCodecKey((Type)mapType)).toProvider((Provider)new SmileCodecProvider((Type)mapType)).in(Scopes.SINGLETON);
    }

    private Key<SmileCodec<?>> getSmileCodecKey(Type type) {
        return Key.get((Type)new MoreTypes.ParameterizedTypeImpl(null, SmileCodec.class, new Type[]{type}));
    }
}

