/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.gen.lambda.LambdaFunctionInterface;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class InvokeFunction
extends SqlScalarFunction {
    public static final InvokeFunction INVOKE_FUNCTION = new InvokeFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(InvokeFunction.class, "invoke", InvokeLambda.class);

    private InvokeFunction() {
        super(new Signature("invoke", FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"function(T)")), false));
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "lambda invoke function";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionManager functionManager) {
        Type returnType = boundVariables.getTypeVariable("T");
        return new ScalarFunctionImplementation(true, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.functionTypeArgumentProperty(InvokeLambda.class)), METHOD_HANDLE.asType(METHOD_HANDLE.type().changeReturnType(Primitives.wrap((Class)returnType.getJavaType()))), this.isDeterministic());
    }

    public static Object invoke(InvokeLambda function) {
        return function.apply();
    }

    @FunctionalInterface
    public static interface InvokeLambda
    extends LambdaFunctionInterface {
        public Object apply();
    }
}

