/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class TypedSet {
    @VisibleForTesting
    public static final DataSize MAX_FUNCTION_MEMORY = new DataSize(4.0, DataSize.Unit.MEGABYTE);
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TypedSet.class).instanceSize();
    private static final int INT_ARRAY_LIST_INSTANCE_SIZE = ClassLayout.parseClass(IntArrayList.class).instanceSize();
    private static final float FILL_RATIO = 0.75f;
    static final long FOUR_MEGABYTES = MAX_FUNCTION_MEMORY.toBytes();
    private final Type elementType;
    private final IntArrayList blockPositionByHash;
    private final BlockBuilder elementBlock;
    private final String functionName;
    private int initialElementBlockOffset;
    private long initialElementBlockSizeInBytes;
    private int size;
    private int hashCapacity;
    private int maxFill;
    private int hashMask;
    private static final int EMPTY_SLOT = -1;
    private boolean containsNullElement;

    public TypedSet(Type elementType, int expectedSize, String functionName) {
        this(elementType, elementType.createBlockBuilder(null, expectedSize), expectedSize, functionName);
    }

    public TypedSet(Type elementType, BlockBuilder blockBuilder, int expectedSize, String functionName) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (Object)"expectedSize must not be negative");
        this.elementType = Objects.requireNonNull(elementType, "elementType must not be null");
        this.elementBlock = Objects.requireNonNull(blockBuilder, "blockBuilder must not be null");
        this.functionName = functionName;
        this.initialElementBlockOffset = this.elementBlock.getPositionCount();
        this.initialElementBlockSizeInBytes = this.elementBlock.getSizeInBytes();
        this.size = 0;
        this.hashCapacity = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = TypedSet.calculateMaxFill(this.hashCapacity);
        this.hashMask = this.hashCapacity - 1;
        this.blockPositionByHash = new IntArrayList(this.hashCapacity);
        this.blockPositionByHash.size(this.hashCapacity);
        for (int i = 0; i < this.hashCapacity; ++i) {
            this.blockPositionByHash.set(i, -1);
        }
        this.containsNullElement = false;
    }

    public long getRetainedSizeInBytes() {
        return (long)(INSTANCE_SIZE + INT_ARRAY_LIST_INSTANCE_SIZE) + this.elementBlock.getRetainedSizeInBytes() + (long)(this.blockPositionByHash.size() * 4);
    }

    public boolean contains(Block block, int position) {
        Objects.requireNonNull(block, "block must not be null");
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position must be >= 0");
        if (block.isNull(position)) {
            return this.containsNullElement;
        }
        return this.blockPositionByHash.get(this.getHashPositionOfElement(block, position)) != -1;
    }

    public void add(Block block, int position) {
        int hashPosition;
        Objects.requireNonNull(block, "block must not be null");
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position must be >= 0");
        if (block.isNull(position)) {
            this.containsNullElement = true;
        }
        if (this.blockPositionByHash.get(hashPosition = this.getHashPositionOfElement(block, position)) == -1) {
            this.addNewElement(hashPosition, block, position);
        }
    }

    public int size() {
        return this.size;
    }

    public int positionOf(Block block, int position) {
        return this.blockPositionByHash.get(this.getHashPositionOfElement(block, position));
    }

    private int getHashPositionOfElement(Block block, int position) {
        int hashPosition = this.getMaskedHash(TypeUtils.hashPosition(this.elementType, block, position));
        int blockPosition;
        while ((blockPosition = this.blockPositionByHash.get(hashPosition).intValue()) != -1) {
            if (TypeUtils.positionEqualsPosition(this.elementType, (Block)this.elementBlock, blockPosition, block, position)) {
                return hashPosition;
            }
            hashPosition = this.getMaskedHash(hashPosition + 1);
        }
        return hashPosition;
    }

    private void addNewElement(int hashPosition, Block block, int position) {
        this.elementType.appendTo(block, position, this.elementBlock);
        if (this.elementBlock.getSizeInBytes() - this.initialElementBlockSizeInBytes > FOUR_MEGABYTES) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT, String.format("The input to %s is too large. More than %s of memory is needed to hold the intermediate hash set.\n", this.functionName, MAX_FUNCTION_MEMORY));
        }
        this.blockPositionByHash.set(hashPosition, this.elementBlock.getPositionCount() - 1);
        ++this.size;
        if (this.size >= this.maxFill) {
            this.rehash();
        }
    }

    private void rehash() {
        int newCapacity;
        long newCapacityLong = (long)this.hashCapacity * 2L;
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        this.hashCapacity = newCapacity = (int)newCapacityLong;
        this.hashMask = newCapacity - 1;
        this.maxFill = TypedSet.calculateMaxFill(newCapacity);
        this.blockPositionByHash.size(newCapacity);
        for (int i = 0; i < newCapacity; ++i) {
            this.blockPositionByHash.set(i, -1);
        }
        for (int blockPosition = this.initialElementBlockOffset; blockPosition < this.elementBlock.getPositionCount(); ++blockPosition) {
            this.blockPositionByHash.set(this.getHashPositionOfElement((Block)this.elementBlock, blockPosition), blockPosition);
        }
    }

    private static int calculateMaxFill(int hashSize) {
        Preconditions.checkArgument((hashSize > 0 ? 1 : 0) != 0, (Object)"hashSize must be greater than 0");
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        Preconditions.checkArgument((hashSize > maxFill ? 1 : 0) != 0, (Object)"hashSize must be larger than maxFill");
        return maxFill;
    }

    private int getMaskedHash(long rawHash) {
        return (int)(rawHash & (long)this.hashMask);
    }
}

