/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.array.IntBigArray;
import com.facebook.presto.array.ShortBigArray;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.google.common.base.Verify;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public abstract class AbstractGroupCollectionAggregationState<T>
extends AbstractGroupedAccumulatorState {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(AbstractGroupCollectionAggregationState.class).instanceSize();
    private static final int MAX_NUM_BLOCKS = 30000;
    private static final short NULL = -1;
    private final ShortBigArray headBlockIndex = new ShortBigArray(-1);
    private final IntBigArray headPosition = new IntBigArray(-1);
    private final ShortBigArray nextBlockIndex = new ShortBigArray(-1);
    private final IntBigArray nextPosition = new IntBigArray(-1);
    private final ShortBigArray tailBlockIndex = new ShortBigArray(-1);
    private final IntBigArray tailPosition = new IntBigArray(-1);
    private final List<PageBuilder> values;
    private final LongList sumPositions;
    private final IntBigArray groupEntryCount;
    private PageBuilder currentPageBuilder;
    private long valueBlocksRetainedSizeInBytes;
    private long totalPositions;
    private long capacity;

    protected AbstractGroupCollectionAggregationState(PageBuilder pageBuilder) {
        this.currentPageBuilder = pageBuilder;
        this.values = new ArrayList<PageBuilder>();
        this.sumPositions = new LongArrayList();
        this.groupEntryCount = new IntBigArray();
        this.values.add(this.currentPageBuilder);
        this.sumPositions.add(0L);
        this.valueBlocksRetainedSizeInBytes = 0L;
        this.totalPositions = 0L;
        this.capacity = 1024L;
        this.nextBlockIndex.ensureCapacity(this.capacity);
        this.nextPosition.ensureCapacity(this.capacity);
        this.groupEntryCount.ensureCapacity(this.capacity);
    }

    public void ensureCapacity(long size) {
        this.headBlockIndex.ensureCapacity(size);
        this.headPosition.ensureCapacity(size);
        this.tailBlockIndex.ensureCapacity(size);
        this.tailPosition.ensureCapacity(size);
        this.groupEntryCount.ensureCapacity(size);
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.headBlockIndex.sizeOf() + this.headPosition.sizeOf() + this.tailBlockIndex.sizeOf() + this.tailPosition.sizeOf() + this.nextBlockIndex.sizeOf() + this.nextPosition.sizeOf() + this.groupEntryCount.sizeOf() + this.valueBlocksRetainedSizeInBytes + this.currentPageBuilder.getRetainedSizeInBytes();
    }

    protected final void prepareAdd() {
        if (this.currentPageBuilder.isFull()) {
            this.valueBlocksRetainedSizeInBytes += this.currentPageBuilder.getRetainedSizeInBytes();
            this.sumPositions.add(this.totalPositions);
            this.currentPageBuilder = this.currentPageBuilder.newPageBuilderLike();
            this.values.add(this.currentPageBuilder);
            Verify.verify((this.values.size() <= 30000 ? 1 : 0) != 0);
        }
        long currentGroupId = this.getGroupId();
        short insertedBlockIndex = (short)(this.values.size() - 1);
        int insertedPosition = this.currentPageBuilder.getPositionCount();
        if (this.totalPositions == this.capacity) {
            this.capacity = (long)((double)this.capacity * 1.5);
            this.nextBlockIndex.ensureCapacity(this.capacity);
            this.nextPosition.ensureCapacity(this.capacity);
        }
        if (this.isEmpty()) {
            this.headBlockIndex.set(currentGroupId, insertedBlockIndex);
            this.headPosition.set(currentGroupId, insertedPosition);
        } else {
            long absoluteTailAddress = this.toAbsolutePosition(this.tailBlockIndex.get(currentGroupId), this.tailPosition.get(currentGroupId));
            this.nextBlockIndex.set(absoluteTailAddress, insertedBlockIndex);
            this.nextPosition.set(absoluteTailAddress, insertedPosition);
        }
        this.tailBlockIndex.set(currentGroupId, insertedBlockIndex);
        this.tailPosition.set(currentGroupId, insertedPosition);
        this.groupEntryCount.increment(currentGroupId);
        this.currentPageBuilder.declarePosition();
        ++this.totalPositions;
    }

    protected final void appendAtChannel(int channel, Block block, int position) {
        this.currentPageBuilder.getType(channel).appendTo(block, position, this.currentPageBuilder.getBlockBuilder(channel));
    }

    public void forEach(T consumer) {
        short currentBlockId = this.headBlockIndex.get(this.getGroupId());
        int currentPosition = this.headPosition.get(this.getGroupId());
        while (currentBlockId != -1) {
            this.accept(consumer, this.values.get(currentBlockId), currentPosition);
            long absoluteCurrentAddress = this.toAbsolutePosition(currentBlockId, currentPosition);
            currentBlockId = this.nextBlockIndex.get(absoluteCurrentAddress);
            currentPosition = this.nextPosition.get(absoluteCurrentAddress);
        }
    }

    public boolean isEmpty() {
        return this.headBlockIndex.get(this.getGroupId()) == -1;
    }

    public final int getEntryCount() {
        return this.groupEntryCount.get(this.getGroupId());
    }

    private long toAbsolutePosition(short blockId, int position) {
        return (Long)this.sumPositions.get((int)blockId) + (long)position;
    }

    protected abstract void accept(T var1, PageBuilder var2, int var3);
}

