/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionInvokerProvider;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.StaticFunctionNamespace;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.type.TypeRegistry;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FunctionManager {
    private final StaticFunctionNamespace staticFunctionNamespace;
    private final FunctionInvokerProvider functionInvokerProvider;

    public FunctionManager(TypeManager typeManager, BlockEncodingSerde blockEncodingSerde, FeaturesConfig featuresConfig) {
        this.staticFunctionNamespace = new StaticFunctionNamespace(typeManager, blockEncodingSerde, featuresConfig, this);
        this.functionInvokerProvider = new FunctionInvokerProvider(this);
        if (typeManager instanceof TypeRegistry) {
            ((TypeRegistry)typeManager).setFunctionManager(this);
        }
    }

    public FunctionInvokerProvider getFunctionInvokerProvider() {
        return this.functionInvokerProvider;
    }

    public void addFunctions(List<? extends SqlFunction> functions) {
        this.staticFunctionNamespace.addFunctions(functions);
    }

    public List<SqlFunction> listFunctions() {
        return this.staticFunctionNamespace.listFunctions();
    }

    public FunctionHandle lookupFunction(QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        return this.staticFunctionNamespace.lookupFunction(name, parameterTypes);
    }

    public FunctionHandle resolveFunction(Session session, QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        return this.staticFunctionNamespace.resolveFunction(name, parameterTypes);
    }

    public WindowFunctionSupplier getWindowFunctionImplementation(FunctionHandle functionHandle) {
        return this.staticFunctionNamespace.getWindowFunctionImplementation(functionHandle);
    }

    public InternalAggregationFunction getAggregateFunctionImplementation(FunctionHandle functionHandle) {
        return this.staticFunctionNamespace.getAggregateFunctionImplementation(functionHandle);
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionHandle functionHandle) {
        return this.staticFunctionNamespace.getScalarFunctionImplementation(functionHandle);
    }

    public boolean isAggregationFunction(QualifiedName name) {
        return this.staticFunctionNamespace.isAggregationFunction(name);
    }

    public FunctionHandle resolveOperator(OperatorType operatorType, List<TypeSignatureProvider> argumentTypes) {
        return this.staticFunctionNamespace.resolveOperator(operatorType, argumentTypes);
    }

    public FunctionHandle lookupCast(CastType castType, TypeSignature fromType, TypeSignature toType) {
        return this.staticFunctionNamespace.lookupCast(castType, fromType, toType);
    }
}

