/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.OperatorSignatureUtils;
import com.facebook.presto.spi.function.OperatorType;

public enum CastType {
    CAST(OperatorSignatureUtils.mangleOperatorName(OperatorType.CAST.name()), true),
    SATURATED_FLOOR_CAST(OperatorSignatureUtils.mangleOperatorName(OperatorType.SATURATED_FLOOR_CAST.name()), true),
    TRY_CAST("TRY_CAST", false),
    JSON_TO_ARRAY_CAST("$internal$json_string_to_array_cast", false),
    JSON_TO_MAP_CAST("$internal$json_string_to_map_cast", false),
    JSON_TO_ROW_CAST("$internal$json_string_to_row_cast", false);

    private final String castName;
    private final boolean isOperatorType;

    private CastType(String castName, boolean isOperatorType) {
        this.castName = castName;
        this.isOperatorType = isOperatorType;
    }

    public String getCastName() {
        return this.castName;
    }

    public boolean isOperatorType() {
        return this.isOperatorType;
    }

    public static OperatorType toOperatorType(CastType castType) {
        switch (castType) {
            case CAST: {
                return OperatorType.CAST;
            }
            case SATURATED_FLOOR_CAST: {
                return OperatorType.SATURATED_FLOOR_CAST;
            }
        }
        throw new IllegalArgumentException(String.format("No OperatorType for CastType %s", new Object[]{castType}));
    }
}

