/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.executor;

import com.facebook.presto.execution.SplitRunner;
import com.facebook.presto.execution.executor.Priority;
import com.facebook.presto.execution.executor.TaskHandle;
import com.facebook.presto.operator.Operator;
import com.google.common.base.Ticker;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.airlift.stats.CpuTimer;
import io.airlift.stats.TimeStat;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class PrioritizedSplitRunner
implements Comparable<PrioritizedSplitRunner> {
    private static final AtomicLong NEXT_WORKER_ID = new AtomicLong();
    private static final Logger log = Logger.get(PrioritizedSplitRunner.class);
    public static final Duration SPLIT_RUN_QUANTA = new Duration(1.0, TimeUnit.SECONDS);
    private final long createdNanos = System.nanoTime();
    private final TaskHandle taskHandle;
    private final int splitId;
    private final long workerId;
    private final SplitRunner split;
    private final Ticker ticker;
    private final SettableFuture<?> finishedFuture = SettableFuture.create();
    private final AtomicBoolean destroyed = new AtomicBoolean();
    protected final AtomicReference<Priority> priority = new AtomicReference<Priority>(new Priority(0, 0L));
    protected final AtomicLong lastRun = new AtomicLong();
    private final AtomicLong lastReady = new AtomicLong();
    private final AtomicLong start = new AtomicLong();
    private final AtomicLong scheduledNanos = new AtomicLong();
    private final AtomicLong waitNanos = new AtomicLong();
    private final AtomicLong cpuTimeNanos = new AtomicLong();
    private final AtomicLong processCalls = new AtomicLong();
    private final CounterStat globalCpuTimeMicros;
    private final CounterStat globalScheduledTimeMicros;
    private final TimeStat blockedQuantaWallTime;
    private final TimeStat unblockedQuantaWallTime;

    PrioritizedSplitRunner(TaskHandle taskHandle, SplitRunner split, Ticker ticker, CounterStat globalCpuTimeMicros, CounterStat globalScheduledTimeMicros, TimeStat blockedQuantaWallTime, TimeStat unblockedQuantaWallTime) {
        this.taskHandle = taskHandle;
        this.splitId = taskHandle.getNextSplitId();
        this.split = split;
        this.ticker = ticker;
        this.workerId = NEXT_WORKER_ID.getAndIncrement();
        this.globalCpuTimeMicros = globalCpuTimeMicros;
        this.globalScheduledTimeMicros = globalScheduledTimeMicros;
        this.blockedQuantaWallTime = blockedQuantaWallTime;
        this.unblockedQuantaWallTime = unblockedQuantaWallTime;
        this.updateLevelPriority();
    }

    public TaskHandle getTaskHandle() {
        return this.taskHandle;
    }

    public ListenableFuture<?> getFinishedFuture() {
        return this.finishedFuture;
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public void destroy() {
        this.destroyed.set(true);
        try {
            this.split.close();
        }
        catch (RuntimeException e) {
            log.error((Throwable)e, "Error closing split for task %s", new Object[]{this.taskHandle.getTaskId()});
        }
    }

    public long getCreatedNanos() {
        return this.createdNanos;
    }

    public boolean isFinished() {
        boolean finished = this.split.isFinished();
        if (finished) {
            this.finishedFuture.set(null);
        }
        return finished || this.destroyed.get() || this.taskHandle.isDestroyed();
    }

    public long getScheduledNanos() {
        return this.scheduledNanos.get();
    }

    public long getCpuTimeNanos() {
        return this.cpuTimeNanos.get();
    }

    public long getWaitNanos() {
        return this.waitNanos.get();
    }

    public ListenableFuture<?> process() {
        try {
            long startNanos = this.ticker.read();
            this.start.compareAndSet(0L, startNanos);
            this.lastReady.compareAndSet(0L, startNanos);
            this.processCalls.incrementAndGet();
            this.waitNanos.getAndAdd(startNanos - this.lastReady.get());
            CpuTimer timer = new CpuTimer();
            ListenableFuture<?> blocked = this.split.processFor(SPLIT_RUN_QUANTA);
            CpuTimer.CpuDuration elapsed = timer.elapsedTime();
            long quantaScheduledNanos = this.ticker.read() - startNanos;
            this.scheduledNanos.addAndGet(quantaScheduledNanos);
            this.priority.set(this.taskHandle.addScheduledNanos(quantaScheduledNanos));
            this.lastRun.set(this.ticker.read());
            if (blocked == Operator.NOT_BLOCKED) {
                this.unblockedQuantaWallTime.add(elapsed.getWall());
            } else {
                this.blockedQuantaWallTime.add(elapsed.getWall());
            }
            long quantaCpuNanos = elapsed.getCpu().roundTo(TimeUnit.NANOSECONDS);
            this.cpuTimeNanos.addAndGet(quantaCpuNanos);
            this.globalCpuTimeMicros.update(quantaCpuNanos / 1000L);
            this.globalScheduledTimeMicros.update(quantaScheduledNanos / 1000L);
            return blocked;
        }
        catch (Throwable e) {
            this.finishedFuture.setException(e);
            throw e;
        }
    }

    public void setReady() {
        this.lastReady.set(this.ticker.read());
    }

    public boolean updateLevelPriority() {
        Priority newPriority = this.taskHandle.getPriority();
        Priority oldPriority = this.priority.getAndSet(newPriority);
        return newPriority.getLevel() != oldPriority.getLevel();
    }

    public void resetLevelPriority() {
        this.priority.set(this.taskHandle.resetLevelPriority());
    }

    @Override
    public int compareTo(PrioritizedSplitRunner o) {
        int result = Long.compare(this.priority.get().getLevelPriority(), o.getPriority().getLevelPriority());
        if (result != 0) {
            return result;
        }
        return Long.compare(this.workerId, o.workerId);
    }

    public int getSplitId() {
        return this.splitId;
    }

    public Priority getPriority() {
        return this.priority.get();
    }

    public String getInfo() {
        return String.format("Split %-15s-%d %s (start = %s, wall = %s ms, cpu = %s ms, wait = %s ms, calls = %s)", this.taskHandle.getTaskId(), this.splitId, this.split.getInfo(), (double)this.start.get() / 1000000.0, (int)((double)(this.ticker.read() - this.start.get()) / 1000000.0), (int)((double)this.cpuTimeNanos.get() / 1000000.0), (int)((double)this.waitNanos.get() / 1000000.0), this.processCalls.get());
    }

    public String toString() {
        return String.format("Split %-15s-%d", this.taskHandle.getTaskId(), this.splitId);
    }
}

