/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.buffer.ArbitraryOutputBuffer;
import com.facebook.presto.execution.buffer.BroadcastOutputBuffer;
import com.facebook.presto.execution.buffer.BufferInfo;
import com.facebook.presto.execution.buffer.BufferResult;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBufferInfo;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.PartitionedOutputBuffer;
import com.facebook.presto.execution.buffer.SerializedPage;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.ExtendedSettableFuture;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;

public class LazyOutputBuffer
implements OutputBuffer {
    private final StateMachine<BufferState> state;
    private final String taskInstanceId;
    private final DataSize maxBufferSize;
    private final Supplier<LocalMemoryContext> systemMemoryContextSupplier;
    private final Executor executor;
    @GuardedBy(value="this")
    private OutputBuffer delegate;
    @GuardedBy(value="this")
    private final Set<OutputBuffers.OutputBufferId> abortedBuffers = new HashSet<OutputBuffers.OutputBufferId>();
    @GuardedBy(value="this")
    private final List<PendingRead> pendingReads = new ArrayList<PendingRead>();

    public LazyOutputBuffer(TaskId taskId, String taskInstanceId, Executor executor, DataSize maxBufferSize, Supplier<LocalMemoryContext> systemMemoryContextSupplier) {
        Objects.requireNonNull(taskId, "taskId is null");
        this.taskInstanceId = Objects.requireNonNull(taskInstanceId, "taskInstanceId is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.state = new StateMachine<BufferState>(taskId + "-buffer", executor, BufferState.OPEN, BufferState.TERMINAL_BUFFER_STATES);
        this.maxBufferSize = Objects.requireNonNull(maxBufferSize, "maxBufferSize is null");
        Preconditions.checkArgument((maxBufferSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxBufferSize must be at least 1");
        this.systemMemoryContextSupplier = Objects.requireNonNull(systemMemoryContextSupplier, "systemMemoryContextSupplier is null");
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<BufferState> stateChangeListener) {
        this.state.addStateChangeListener(stateChangeListener);
    }

    @Override
    public boolean isFinished() {
        return this.state.get() == BufferState.FINISHED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getUtilization() {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            outputBuffer = this.delegate;
        }
        if (outputBuffer == null) {
            return 1.0;
        }
        return outputBuffer.getUtilization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOverutilized() {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            outputBuffer = this.delegate;
        }
        return outputBuffer != null && outputBuffer.isOverutilized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputBufferInfo getInfo() {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            outputBuffer = this.delegate;
        }
        if (outputBuffer == null) {
            BufferState state = this.state.get();
            return new OutputBufferInfo("UNINITIALIZED", state, state.canAddBuffers(), state.canAddPages(), 0L, 0L, 0L, 0L, (List<BufferInfo>)ImmutableList.of());
        }
        return outputBuffer.getInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutputBuffers(OutputBuffers newOutputBuffers) {
        OutputBuffer outputBuffer;
        ImmutableSet abortedBuffers = ImmutableSet.of();
        ImmutableList pendingReads = ImmutableList.of();
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            if (this.delegate == null) {
                if (this.state.get().isTerminal()) {
                    return;
                }
                switch (newOutputBuffers.getType()) {
                    case PARTITIONED: {
                        this.delegate = new PartitionedOutputBuffer(this.taskInstanceId, this.state, newOutputBuffers, this.maxBufferSize, this.systemMemoryContextSupplier, this.executor);
                        break;
                    }
                    case BROADCAST: {
                        this.delegate = new BroadcastOutputBuffer(this.taskInstanceId, this.state, this.maxBufferSize, this.systemMemoryContextSupplier, this.executor);
                        break;
                    }
                    case ARBITRARY: {
                        this.delegate = new ArbitraryOutputBuffer(this.taskInstanceId, this.state, this.maxBufferSize, this.systemMemoryContextSupplier, this.executor);
                    }
                }
                abortedBuffers = ImmutableSet.copyOf(this.abortedBuffers);
                this.abortedBuffers.clear();
                pendingReads = ImmutableList.copyOf(this.pendingReads);
                this.pendingReads.clear();
            }
            outputBuffer = this.delegate;
        }
        outputBuffer.setOutputBuffers(newOutputBuffers);
        abortedBuffers.forEach(outputBuffer::abort);
        for (PendingRead pendingRead : pendingReads) {
            pendingRead.process(outputBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<BufferResult> get(OutputBuffers.OutputBufferId bufferId, long token, DataSize maxSize) {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            if (this.delegate == null) {
                if (this.state.get() == BufferState.FINISHED) {
                    return Futures.immediateFuture((Object)BufferResult.emptyResults(this.taskInstanceId, 0L, true));
                }
                PendingRead pendingRead = new PendingRead(bufferId, token, maxSize);
                this.pendingReads.add(pendingRead);
                return pendingRead.getFutureResult();
            }
            outputBuffer = this.delegate;
        }
        return outputBuffer.get(bufferId, token, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledge(OutputBuffers.OutputBufferId bufferId, long token) {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"delegate is null");
            outputBuffer = this.delegate;
        }
        outputBuffer.acknowledge(bufferId, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(OutputBuffers.OutputBufferId bufferId) {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            if (this.delegate == null) {
                this.abortedBuffers.add(bufferId);
                return;
            }
            outputBuffer = this.delegate;
        }
        outputBuffer.abort(bufferId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<?> isFull() {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"Buffer has not been initialized");
            outputBuffer = this.delegate;
        }
        return outputBuffer.isFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLifespanCompletionCallback(Consumer<Lifespan> callback) {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"Buffer has not been initialized");
            outputBuffer = this.delegate;
        }
        outputBuffer.registerLifespanCompletionCallback(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Lifespan lifespan, List<SerializedPage> pages) {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"Buffer has not been initialized");
            outputBuffer = this.delegate;
        }
        outputBuffer.enqueue(lifespan, pages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Lifespan lifespan, int partition, List<SerializedPage> pages) {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"Buffer has not been initialized");
            outputBuffer = this.delegate;
        }
        outputBuffer.enqueue(lifespan, partition, pages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNoMorePages() {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"Buffer has not been initialized");
            outputBuffer = this.delegate;
        }
        outputBuffer.setNoMorePages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        OutputBuffer outputBuffer;
        ImmutableList pendingReads = ImmutableList.of();
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            if (this.delegate == null) {
                if (!this.state.setIf(BufferState.FINISHED, state -> !state.isTerminal())) {
                    return;
                }
                pendingReads = ImmutableList.copyOf(this.pendingReads);
                this.pendingReads.clear();
            }
            outputBuffer = this.delegate;
        }
        if (outputBuffer == null) {
            for (PendingRead pendingRead : pendingReads) {
                pendingRead.getFutureResult().set((Object)BufferResult.emptyResults(this.taskInstanceId, 0L, true));
            }
            return;
        }
        outputBuffer.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail() {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            if (this.delegate == null) {
                this.state.setIf(BufferState.FAILED, state -> !state.isTerminal());
                return;
            }
            outputBuffer = this.delegate;
        }
        outputBuffer.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNoMorePagesForLifespan(Lifespan lifespan) {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"Buffer has not been initialized");
            outputBuffer = this.delegate;
        }
        outputBuffer.setNoMorePagesForLifespan(lifespan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinishedForLifespan(Lifespan lifespan) {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            Preconditions.checkState((this.delegate != null ? 1 : 0) != 0, (Object)"Buffer has not been initialized");
            outputBuffer = this.delegate;
        }
        return outputBuffer.isFinishedForLifespan(lifespan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPeakMemoryUsage() {
        OutputBuffer outputBuffer;
        LazyOutputBuffer lazyOutputBuffer = this;
        synchronized (lazyOutputBuffer) {
            outputBuffer = this.delegate;
        }
        if (outputBuffer != null) {
            return outputBuffer.getPeakMemoryUsage();
        }
        return 0L;
    }

    private static class PendingRead {
        private final OutputBuffers.OutputBufferId bufferId;
        private final long startingSequenceId;
        private final DataSize maxSize;
        private final ExtendedSettableFuture<BufferResult> futureResult = ExtendedSettableFuture.create();

        public PendingRead(OutputBuffers.OutputBufferId bufferId, long startingSequenceId, DataSize maxSize) {
            this.bufferId = Objects.requireNonNull(bufferId, "bufferId is null");
            this.startingSequenceId = startingSequenceId;
            this.maxSize = Objects.requireNonNull(maxSize, "maxSize is null");
        }

        public ExtendedSettableFuture<BufferResult> getFutureResult() {
            return this.futureResult;
        }

        public void process(OutputBuffer delegate) {
            if (this.futureResult.isDone()) {
                return;
            }
            try {
                ListenableFuture<BufferResult> result = delegate.get(this.bufferId, this.startingSequenceId, this.maxSize);
                this.futureResult.setAsync(result);
            }
            catch (Exception e) {
                this.futureResult.setException((Throwable)e);
            }
        }
    }
}

