/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanFragment;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StageInfo {
    private final StageId stageId;
    private final StageState state;
    private final URI self;
    private final PlanFragment plan;
    private final List<Type> types;
    private final StageStats stageStats;
    private final List<TaskInfo> tasks;
    private final List<StageInfo> subStages;
    private final ExecutionFailureInfo failureCause;

    @JsonCreator
    public StageInfo(@JsonProperty(value="stageId") StageId stageId, @JsonProperty(value="state") StageState state, @JsonProperty(value="self") URI self, @JsonProperty(value="plan") @Nullable PlanFragment plan, @JsonProperty(value="types") List<Type> types, @JsonProperty(value="stageStats") StageStats stageStats, @JsonProperty(value="tasks") List<TaskInfo> tasks, @JsonProperty(value="subStages") List<StageInfo> subStages, @JsonProperty(value="failureCause") ExecutionFailureInfo failureCause) {
        Objects.requireNonNull(stageId, "stageId is null");
        Objects.requireNonNull(state, "state is null");
        Objects.requireNonNull(self, "self is null");
        Objects.requireNonNull(stageStats, "stageStats is null");
        Objects.requireNonNull(tasks, "tasks is null");
        Objects.requireNonNull(subStages, "subStages is null");
        this.stageId = stageId;
        this.state = state;
        this.self = self;
        this.plan = plan;
        this.types = types;
        this.stageStats = stageStats;
        this.tasks = ImmutableList.copyOf(tasks);
        this.subStages = subStages;
        this.failureCause = failureCause;
    }

    @JsonProperty
    public StageId getStageId() {
        return this.stageId;
    }

    @JsonProperty
    public StageState getState() {
        return this.state;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    @Nullable
    public PlanFragment getPlan() {
        return this.plan;
    }

    @JsonProperty
    public List<Type> getTypes() {
        return this.types;
    }

    @JsonProperty
    public StageStats getStageStats() {
        return this.stageStats;
    }

    @JsonProperty
    public List<TaskInfo> getTasks() {
        return this.tasks;
    }

    @JsonProperty
    public List<StageInfo> getSubStages() {
        return this.subStages;
    }

    @JsonProperty
    public ExecutionFailureInfo getFailureCause() {
        return this.failureCause;
    }

    public boolean isFinalStageInfo() {
        return this.state.isDone() && this.tasks.stream().allMatch(taskInfo -> taskInfo.getTaskStatus().getState().isDone());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stageId", (Object)this.stageId).add("state", (Object)this.state).toString();
    }

    public static List<StageInfo> getAllStages(Optional<StageInfo> stageInfo) {
        ImmutableList.Builder collector = ImmutableList.builder();
        StageInfo.addAllStages(stageInfo, (ImmutableList.Builder<StageInfo>)collector);
        return collector.build();
    }

    private static void addAllStages(Optional<StageInfo> stageInfo, ImmutableList.Builder<StageInfo> collector) {
        stageInfo.ifPresent(stage -> {
            collector.add(stage);
            stage.getSubStages().stream().forEach(subStage -> StageInfo.addAllStages(Optional.ofNullable(subStage), collector));
        });
    }

    public boolean isCompleteInfo() {
        return this.state.isDone() && this.tasks.stream().allMatch(taskInfo -> taskInfo.getTaskStatus().getState().isDone());
    }
}

