/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.ExceededCpuLimitException;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.execution.ClusterSizeMonitor;
import com.facebook.presto.execution.FailedQueryExecution;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.ManagedQueryExecution;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryPreparer;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.QueryTracker;
import com.facebook.presto.execution.SqlQueryManagerStats;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.execution.warnings.WarningCollectorFactory;
import com.facebook.presto.memory.ClusterMemoryManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.server.SessionPropertyDefaults;
import com.facebook.presto.server.SessionSupplier;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.facebook.presto.spi.resourceGroups.SelectionCriteria;
import com.facebook.presto.sql.SqlEnvironmentConfig;
import com.facebook.presto.sql.SqlPath;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.StatementUtils;
import com.facebook.presto.version.EmbedVersion;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class SqlQueryManager
implements QueryManager {
    private static final Logger log = Logger.get(SqlQueryManager.class);
    private final QueryPreparer queryPreparer;
    private final EmbedVersion embedVersion;
    private final ExecutorService queryExecutor;
    private final ThreadPoolExecutorMBean queryExecutorMBean;
    private final ResourceGroupManager<?> resourceGroupManager;
    private final ClusterMemoryManager memoryManager;
    private final Optional<String> path;
    private final int maxQueryLength;
    private final Duration maxQueryCpuTime;
    private final QueryTracker<QueryExecution> queryTracker;
    private final ScheduledExecutorService queryManagementExecutor;
    private final ThreadPoolExecutorMBean queryManagementExecutorMBean;
    private final QueryMonitor queryMonitor;
    private final LocationFactory locationFactory;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final QueryIdGenerator queryIdGenerator;
    private final SessionSupplier sessionSupplier;
    private final SessionPropertyDefaults sessionPropertyDefaults;
    private final ClusterSizeMonitor clusterSizeMonitor;
    private final Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories;
    private final SqlQueryManagerStats stats = new SqlQueryManagerStats();
    private final WarningCollectorFactory warningCollectorFactory;

    @Inject
    public SqlQueryManager(QueryPreparer queryPreparer, EmbedVersion embedVersion, NodeSchedulerConfig nodeSchedulerConfig, QueryManagerConfig queryManagerConfig, SqlEnvironmentConfig sqlEnvironmentConfig, QueryMonitor queryMonitor, ResourceGroupManager<?> resourceGroupManager, ClusterMemoryManager memoryManager, LocationFactory locationFactory, TransactionManager transactionManager, AccessControl accessControl, QueryIdGenerator queryIdGenerator, SessionSupplier sessionSupplier, SessionPropertyDefaults sessionPropertyDefaults, ClusterSizeMonitor clusterSizeMonitor, Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories, WarningCollectorFactory warningCollectorFactory) {
        this.queryPreparer = Objects.requireNonNull(queryPreparer, "queryPreparer is null");
        this.embedVersion = Objects.requireNonNull(embedVersion, "embedVersion is null");
        this.executionFactories = Objects.requireNonNull(executionFactories, "executionFactories is null");
        this.queryExecutor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"query-scheduler-%s"));
        this.queryExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.queryExecutor);
        Objects.requireNonNull(nodeSchedulerConfig, "nodeSchedulerConfig is null");
        Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.queryIdGenerator = Objects.requireNonNull(queryIdGenerator, "queryIdGenerator is null");
        this.sessionSupplier = Objects.requireNonNull(sessionSupplier, "sessionSupplier is null");
        this.sessionPropertyDefaults = Objects.requireNonNull(sessionPropertyDefaults, "sessionPropertyDefaults is null");
        this.clusterSizeMonitor = Objects.requireNonNull(clusterSizeMonitor, "clusterSizeMonitor is null");
        this.path = sqlEnvironmentConfig.getPath();
        this.maxQueryLength = queryManagerConfig.getMaxQueryLength();
        this.maxQueryCpuTime = queryManagerConfig.getQueryMaxCpuTime();
        this.warningCollectorFactory = Objects.requireNonNull(warningCollectorFactory, "warningCollectorFactory is null");
        this.queryManagementExecutor = Executors.newScheduledThreadPool(queryManagerConfig.getQueryManagerExecutorPoolSize(), Threads.threadsNamed((String)"query-management-%s"));
        this.queryManagementExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)this.queryManagementExecutor));
        this.queryTracker = new QueryTracker(queryManagerConfig, this.queryManagementExecutor);
    }

    @PostConstruct
    public void start() {
        this.queryTracker.start();
        this.queryManagementExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.enforceMemoryLimits();
            }
            catch (Throwable e) {
                log.error(e, "Error enforcing memory limits");
            }
            try {
                this.enforceCpuLimits();
            }
            catch (Throwable e) {
                log.error(e, "Error enforcing query CPU time limits");
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        this.queryTracker.stop();
        this.queryManagementExecutor.shutdownNow();
        this.queryExecutor.shutdownNow();
    }

    @Override
    public List<BasicQueryInfo> getQueries() {
        return (List)this.queryTracker.getAllQueries().stream().map(queryExecution -> {
            try {
                return queryExecution.getBasicQueryInfo();
            }
            catch (RuntimeException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void addOutputInfoListener(QueryId queryId, Consumer<QueryExecution.QueryOutputInfo> listener) {
        Objects.requireNonNull(listener, "listener is null");
        this.queryTracker.getQuery(queryId).addOutputInfoListener(listener);
    }

    @Override
    public void addStateChangeListener(QueryId queryId, StateMachine.StateChangeListener<QueryState> listener) {
        Objects.requireNonNull(listener, "listener is null");
        this.queryTracker.getQuery(queryId).addStateChangeListener(listener);
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryId queryId, QueryState currentState) {
        return this.queryTracker.tryGetQuery(queryId).map(query -> query.getStateChange(currentState)).orElseGet(() -> Futures.immediateFailedFuture((Throwable)new NoSuchElementException()));
    }

    @Override
    public BasicQueryInfo getQueryInfo(QueryId queryId) {
        return this.queryTracker.getQuery(queryId).getBasicQueryInfo();
    }

    @Override
    public QueryInfo getFullQueryInfo(QueryId queryId) {
        return this.queryTracker.getQuery(queryId).getQueryInfo();
    }

    public Plan getQueryPlan(QueryId queryId) {
        return this.queryTracker.getQuery(queryId).getQueryPlan();
    }

    public void addFinalQueryInfoListener(QueryId queryId, StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.queryTracker.getQuery(queryId).addFinalQueryInfoListener(stateChangeListener);
    }

    @Override
    public QueryState getQueryState(QueryId queryId) {
        return this.queryTracker.getQuery(queryId).getState();
    }

    @Override
    public void recordHeartbeat(QueryId queryId) {
        this.queryTracker.tryGetQuery(queryId).ifPresent(QueryExecution::recordHeartbeat);
    }

    @Override
    public QueryId createQueryId() {
        return this.queryIdGenerator.createNextQueryId();
    }

    @Override
    public ListenableFuture<?> createQuery(QueryId queryId, SessionContext sessionContext, String query) {
        QueryCreationFuture queryCreationFuture = new QueryCreationFuture();
        this.queryExecutor.submit(this.embedVersion.embedVersion(() -> {
            try {
                this.createQueryInternal(queryId, sessionContext, query, this.resourceGroupManager);
                queryCreationFuture.set(null);
            }
            catch (Throwable e) {
                queryCreationFuture.setException(e);
            }
        }));
        return queryCreationFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C> void createQueryInternal(QueryId queryId, SessionContext sessionContext, String query, ResourceGroupManager<C> resourceGroupManager) {
        Object queryExecution;
        QueryPreparer.PreparedQuery preparedQuery;
        Objects.requireNonNull(queryId, "queryId is null");
        Objects.requireNonNull(sessionContext, "sessionFactory is null");
        Objects.requireNonNull(query, "query is null");
        Preconditions.checkArgument((!query.isEmpty() ? 1 : 0) != 0, (Object)"query must not be empty string");
        Preconditions.checkArgument((!this.queryTracker.tryGetQuery(queryId).isPresent() ? 1 : 0) != 0, (String)"query %s already exists", (Object)queryId);
        Session session = null;
        SelectionContext<C> selectionContext = null;
        Optional<QueryType> queryType = Optional.empty();
        try {
            this.clusterSizeMonitor.verifyInitialMinimumWorkersRequirement();
            if (query.length() > this.maxQueryLength) {
                int queryLength = query.length();
                query = query.substring(0, this.maxQueryLength);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_TEXT_TOO_LARGE, String.format("Query text length (%s) exceeds the maximum length (%s)", queryLength, this.maxQueryLength));
            }
            session = this.sessionSupplier.createSession(queryId, sessionContext);
            WarningCollector warningCollector = this.warningCollectorFactory.create();
            preparedQuery = this.queryPreparer.prepareQuery(session, query, warningCollector);
            queryType = StatementUtils.getQueryType(preparedQuery.getStatement().getClass());
            selectionContext = resourceGroupManager.selectGroup(new SelectionCriteria(sessionContext.getIdentity().getPrincipal().isPresent(), sessionContext.getIdentity().getUser(), Optional.ofNullable(sessionContext.getSource()), sessionContext.getClientTags(), sessionContext.getResourceEstimates(), queryType.map(Enum::name)));
            session = this.sessionPropertyDefaults.newSessionWithDefaultProperties(session, queryType.map(Enum::name), selectionContext.getResourceGroupId());
            this.transactionManager.activateTransaction(session, StatementUtils.isTransactionControlStatement(preparedQuery.getStatement()), this.accessControl);
            QueryExecution.QueryExecutionFactory<?> queryExecutionFactory = this.executionFactories.get(preparedQuery.getStatement().getClass());
            if (queryExecutionFactory == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported statement type: " + preparedQuery.getStatement().getClass().getSimpleName());
            }
            queryExecution = queryExecutionFactory.createQueryExecution(query, session, preparedQuery, selectionContext.getResourceGroupId(), warningCollector, queryType);
        }
        catch (RuntimeException e) {
            if (session == null) {
                session = Session.builder(new SessionPropertyManager()).setQueryId(queryId).setIdentity(sessionContext.getIdentity()).setPath(new SqlPath(Optional.empty())).build();
            }
            QueryStateMachine.QUERY_STATE_LOG.debug((Throwable)e, "Query %s failed", new Object[]{session.getQueryId()});
            session.getTransactionId().ifPresent(this.transactionManager::fail);
            FailedQueryExecution execution = new FailedQueryExecution(session, query, this.locationFactory.createQueryLocation(queryId), Optional.ofNullable(selectionContext).map(SelectionContext::getResourceGroupId), queryType, this.queryExecutor, e);
            try {
                this.queryTracker.addQuery(execution);
                BasicQueryInfo queryInfo = execution.getBasicQueryInfo();
                this.queryMonitor.queryCreatedEvent(queryInfo);
                this.queryMonitor.queryImmediateFailureEvent(queryInfo, Failures.toFailure(e));
                this.stats.queryQueued();
                this.stats.queryStarted();
                this.stats.queryStopped();
                this.stats.queryFinished(execution.getQueryInfo());
            }
            finally {
                this.queryTracker.expireQuery(queryId);
            }
            return;
        }
        this.queryMonitor.queryCreatedEvent(queryExecution.getBasicQueryInfo());
        queryExecution.addFinalQueryInfoListener(finalQueryInfo -> {
            try {
                this.stats.queryFinished((QueryInfo)finalQueryInfo);
                this.queryMonitor.queryCompletedEvent((QueryInfo)finalQueryInfo);
            }
            finally {
                this.queryTracker.expireQuery(queryId);
            }
        });
        this.addStatsListeners((QueryExecution)queryExecution);
        if (!this.queryTracker.addQuery((QueryExecution)queryExecution)) {
            return;
        }
        try {
            resourceGroupManager.submit(preparedQuery.getStatement(), (ManagedQueryExecution)queryExecution, selectionContext, this.queryExecutor);
        }
        catch (Throwable e) {
            this.failQuery(queryId, e);
        }
    }

    @Override
    public void failQuery(QueryId queryId, Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.queryTracker.tryGetQuery(queryId).ifPresent(query -> query.fail(cause));
    }

    @Override
    public void cancelQuery(QueryId queryId) {
        log.debug("Cancel query %s", new Object[]{queryId});
        this.queryTracker.tryGetQuery(queryId).ifPresent(QueryExecution::cancelQuery);
    }

    @Override
    public void cancelStage(StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        log.debug("Cancel stage %s", new Object[]{stageId});
        this.queryTracker.tryGetQuery(stageId.getQueryId()).ifPresent(query -> query.cancelStage(stageId));
    }

    @Override
    @Managed
    @Flatten
    public SqlQueryManagerStats getStats() {
        return this.stats;
    }

    @Managed(description="Query scheduler executor")
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.queryExecutorMBean;
    }

    @Managed(description="Query query management executor")
    @Nested
    public ThreadPoolExecutorMBean getManagementExecutor() {
        return this.queryManagementExecutorMBean;
    }

    private void enforceMemoryLimits() {
        List runningQueries = (List)this.queryTracker.getAllQueries().stream().filter(query -> query.getState() == QueryState.RUNNING).collect(ImmutableList.toImmutableList());
        this.memoryManager.process(runningQueries, this::getQueries);
    }

    private void enforceCpuLimits() {
        for (QueryExecution query : this.queryTracker.getAllQueries()) {
            Duration cpuTime = query.getTotalCpuTime();
            Duration sessionLimit = SystemSessionProperties.getQueryMaxCpuTime(query.getSession());
            Duration limit = (Duration)Ordering.natural().min((Object)this.maxQueryCpuTime, (Object)sessionLimit);
            if (cpuTime.compareTo(limit) <= 0) continue;
            query.fail((Throwable)((Object)new ExceededCpuLimitException(limit)));
        }
    }

    private void addStatsListeners(QueryExecution queryExecution) {
        Object lock = new Object();
        this.stats.queryQueued();
        AtomicBoolean started = new AtomicBoolean();
        queryExecution.addStateChangeListener(newValue -> {
            Object object = lock;
            synchronized (object) {
                if (newValue == QueryState.RUNNING && !started.getAndSet(true)) {
                    this.stats.queryStarted();
                }
            }
        });
        AtomicBoolean stopped = new AtomicBoolean();
        queryExecution.addStateChangeListener(newValue -> {
            Object object = lock;
            synchronized (object) {
                if (newValue.isDone() && !stopped.getAndSet(true) && started.get()) {
                    this.stats.queryStopped();
                }
            }
        });
    }

    private static class QueryCreationFuture
    extends AbstractFuture<QueryInfo> {
        private QueryCreationFuture() {
        }

        protected boolean set(QueryInfo value) {
            return super.set((Object)value);
        }

        protected boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }
    }
}

