/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.StatsUtil;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.RowExpressionInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;

public class ValuesStatsRule
implements ComposableStatsCalculator.Rule<ValuesNode> {
    private static final Pattern<ValuesNode> PATTERN = Patterns.values();
    private final Metadata metadata;

    public ValuesStatsRule(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Pattern<ValuesNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Optional<PlanNodeStatsEstimate> calculate(ValuesNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        PlanNodeStatsEstimate.Builder statsBuilder = PlanNodeStatsEstimate.builder();
        statsBuilder.setOutputRowCount(node.getRows().size());
        for (int symbolId = 0; symbolId < node.getOutputSymbols().size(); ++symbolId) {
            Symbol symbol = node.getOutputSymbols().get(symbolId);
            List<Object> symbolValues = this.getSymbolValues(node, symbolId, session, types.get(symbol));
            statsBuilder.addSymbolStatistics(symbol, this.buildSymbolStatistics(symbolValues, session, types.get(symbol)));
        }
        return Optional.of(statsBuilder.build());
    }

    private List<Object> getSymbolValues(ValuesNode valuesNode, int symbolId, Session session, Type symbolType) {
        if (UnknownType.UNKNOWN.equals(symbolType)) {
            return IntStream.range(0, valuesNode.getRows().size()).mapToObj(rowId -> null).collect(Collectors.toList());
        }
        return valuesNode.getRows().stream().map(row -> (RowExpression)row.get(symbolId)).map(rowExpression -> {
            if (OriginalExpressionUtils.isExpression(rowExpression)) {
                return ExpressionInterpreter.evaluateConstantExpression(OriginalExpressionUtils.castToExpression(rowExpression), symbolType, this.metadata, session, (List<Expression>)ImmutableList.of());
            }
            return RowExpressionInterpreter.evaluateConstantRowExpression(rowExpression, this.metadata, session);
        }).collect(Collectors.toList());
    }

    private SymbolStatsEstimate buildSymbolStatistics(List<Object> values, Session session, Type type) {
        List nonNullValues = (List)values.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        if (nonNullValues.isEmpty()) {
            return SymbolStatsEstimate.zero();
        }
        double[] valuesAsDoubles = nonNullValues.stream().map(value -> StatsUtil.toStatsRepresentation(this.metadata, session, type, value)).filter(OptionalDouble::isPresent).mapToDouble(OptionalDouble::getAsDouble).toArray();
        double lowValue = DoubleStream.of(valuesAsDoubles).min().orElse(Double.NEGATIVE_INFINITY);
        double highValue = DoubleStream.of(valuesAsDoubles).max().orElse(Double.POSITIVE_INFINITY);
        double valuesCount = values.size();
        double nonNullValuesCount = nonNullValues.size();
        long distinctValuesCount = nonNullValues.stream().distinct().count();
        return SymbolStatsEstimate.builder().setNullsFraction((valuesCount - nonNullValuesCount) / valuesCount).setLowValue(lowValue).setHighValue(highValue).setDistinctValuesCount(distinctValuesCount).build();
    }
}

