/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.Node;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntSupplier;
import javax.inject.Inject;

public class TaskCountEstimator {
    private final IntSupplier numberOfNodes;

    @Inject
    public TaskCountEstimator(NodeSchedulerConfig nodeSchedulerConfig, InternalNodeManager nodeManager) {
        Objects.requireNonNull(nodeSchedulerConfig, "nodeSchedulerConfig is null");
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.numberOfNodes = () -> {
            Set<Node> activeNodes = nodeManager.getAllNodes().getActiveNodes();
            if (nodeSchedulerConfig.isIncludeCoordinator()) {
                return activeNodes.size();
            }
            return Math.toIntExact(activeNodes.stream().filter(node -> !node.isCoordinator()).count());
        };
    }

    public TaskCountEstimator(IntSupplier numberOfNodes) {
        this.numberOfNodes = Objects.requireNonNull(numberOfNodes, "numberOfNodes is null");
    }

    public int estimateSourceDistributedTaskCount() {
        return this.numberOfNodes.getAsInt();
    }
}

