/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.connector.system.StaticSystemTablesProvider;
import com.facebook.presto.connector.system.SystemPageSourceProvider;
import com.facebook.presto.connector.system.SystemSplitManager;
import com.facebook.presto.connector.system.SystemTablesMetadata;
import com.facebook.presto.connector.system.SystemTablesProvider;
import com.facebook.presto.connector.system.SystemTransactionHandle;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.transaction.InternalConnector;
import com.facebook.presto.transaction.TransactionId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class SystemConnector
implements InternalConnector {
    private final ConnectorId connectorId;
    private final ConnectorMetadata metadata;
    private final ConnectorSplitManager splitManager;
    private final ConnectorPageSourceProvider pageSourceProvider;
    private final Function<TransactionId, ConnectorTransactionHandle> transactionHandleFunction;
    private final List<PropertyMetadata<?>> sessionProperties;

    public SystemConnector(ConnectorId connectorId, InternalNodeManager nodeManager, Set<SystemTable> tables, Function<TransactionId, ConnectorTransactionHandle> transactionHandleFunction) {
        this(connectorId, nodeManager, new StaticSystemTablesProvider(tables), transactionHandleFunction, (List<PropertyMetadata<?>>)ImmutableList.of());
    }

    public SystemConnector(ConnectorId connectorId, InternalNodeManager nodeManager, SystemTablesProvider tables, Function<TransactionId, ConnectorTransactionHandle> transactionHandleFunction, List<PropertyMetadata<?>> sessionProperties) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        Objects.requireNonNull(tables, "tables is null");
        Objects.requireNonNull(transactionHandleFunction, "transactionHandleFunction is null");
        this.connectorId = connectorId;
        this.metadata = new SystemTablesMetadata(connectorId, tables);
        this.splitManager = new SystemSplitManager(nodeManager, tables);
        this.pageSourceProvider = new SystemPageSourceProvider(tables);
        this.transactionHandleFunction = transactionHandleFunction;
        this.sessionProperties = sessionProperties;
    }

    @Override
    public ConnectorTransactionHandle beginTransaction(TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly) {
        return new SystemTransactionHandle(this.connectorId, transactionId, this.transactionHandleFunction);
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }
}

