/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SystemTable;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.inject.Inject;
import org.joda.time.DateTime;

public class QuerySystemTable
implements SystemTable {
    public static final SchemaTableName QUERY_TABLE_NAME = new SchemaTableName("runtime", "queries");
    public static final ConnectorTableMetadata QUERY_TABLE = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(QUERY_TABLE_NAME).column("query_id", (Type)VarcharType.createUnboundedVarcharType()).column("state", (Type)VarcharType.createUnboundedVarcharType()).column("user", (Type)VarcharType.createUnboundedVarcharType()).column("source", (Type)VarcharType.createUnboundedVarcharType()).column("query", (Type)VarcharType.createUnboundedVarcharType()).column("resource_group_id", (Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType())).column("queued_time_ms", (Type)BigintType.BIGINT).column("analysis_time_ms", (Type)BigintType.BIGINT).column("distributed_planning_time_ms", (Type)BigintType.BIGINT).column("created", (Type)TimestampType.TIMESTAMP).column("started", (Type)TimestampType.TIMESTAMP).column("last_heartbeat", (Type)TimestampType.TIMESTAMP).column("end", (Type)TimestampType.TIMESTAMP).build();
    private final QueryManager queryManager;

    @Inject
    public QuerySystemTable(QueryManager queryManager) {
        this.queryManager = queryManager;
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.ALL_COORDINATORS;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return QUERY_TABLE;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)QUERY_TABLE);
        List queryInfos = (List)this.queryManager.getQueries().stream().map(BasicQueryInfo::getQueryId).map(queryId -> {
            try {
                return this.queryManager.getFullQueryInfo((QueryId)queryId);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        for (QueryInfo queryInfo : queryInfos) {
            QueryStats queryStats = queryInfo.getQueryStats();
            table.addRow(new Object[]{queryInfo.getQueryId().toString(), queryInfo.getState().toString(), queryInfo.getSession().getUser(), queryInfo.getSession().getSource().orElse(null), queryInfo.getQuery(), queryInfo.getResourceGroupId().map(QuerySystemTable::resourceGroupIdToBlock).orElse(null), QuerySystemTable.toMillis(queryStats.getQueuedTime()), QuerySystemTable.toMillis(queryStats.getAnalysisTime()), QuerySystemTable.toMillis(queryStats.getDistributedPlanningTime()), QuerySystemTable.toTimeStamp(queryStats.getCreateTime()), QuerySystemTable.toTimeStamp(queryStats.getExecutionStartTime()), QuerySystemTable.toTimeStamp(queryStats.getLastHeartbeat()), QuerySystemTable.toTimeStamp(queryStats.getEndTime())});
        }
        return table.build().cursor();
    }

    private static Block resourceGroupIdToBlock(ResourceGroupId resourceGroupId) {
        Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        List segments = resourceGroupId.getSegments();
        BlockBuilder blockBuilder = VarcharType.createUnboundedVarcharType().createBlockBuilder(null, segments.size());
        for (String segment : segments) {
            VarcharType.createUnboundedVarcharType().writeSlice(blockBuilder, Slices.utf8Slice((String)segment));
        }
        return blockBuilder.build();
    }

    private static Long toMillis(Duration duration) {
        if (duration == null) {
            return null;
        }
        return duration.toMillis();
    }

    private static Long toTimeStamp(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.getMillis();
    }
}

