/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.DoubleRange;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.ShowStats;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Values;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ShowStatsRewrite
implements StatementRewrite.Rewrite {
    private static final Expression NULL_DOUBLE = new Cast((Expression)new NullLiteral(), "double");
    private static final Expression NULL_VARCHAR = new Cast((Expression)new NullLiteral(), "varchar");

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, AccessControl accessControl, WarningCollector warningCollector) {
        return (Statement)new Visitor(metadata, session, parameters, queryExplainer, warningCollector).process((Node)node, null);
    }

    private static class Visitor
    extends AstVisitor<Node, Void> {
        private final Metadata metadata;
        private final Session session;
        private final List<Expression> parameters;
        private final Optional<QueryExplainer> queryExplainer;
        private final WarningCollector warningCollector;

        public Visitor(Metadata metadata, Session session, List<Expression> parameters, Optional<QueryExplainer> queryExplainer, WarningCollector warningCollector) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.parameters = Objects.requireNonNull(parameters, "parameters is null");
            this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        protected Node visitShowStats(ShowStats node, Void context) {
            Preconditions.checkState((boolean)this.queryExplainer.isPresent(), (Object)"Query explainer must be provided for SHOW STATS SELECT");
            if (node.getRelation() instanceof TableSubquery) {
                Query query = ((TableSubquery)node.getRelation()).getQuery();
                QuerySpecification specification = (QuerySpecification)query.getQueryBody();
                Plan plan = this.queryExplainer.get().getLogicalPlan(this.session, (Statement)new Query(Optional.empty(), (QueryBody)specification, Optional.empty(), Optional.empty()), this.parameters, this.warningCollector);
                this.validateShowStatsSubquery(node, query, specification, plan);
                Table table = (Table)specification.getFrom().get();
                Constraint<ColumnHandle> constraint = this.getConstraint(plan);
                return this.rewriteShowStats(node, table, constraint);
            }
            if (node.getRelation() instanceof Table) {
                Table table = (Table)node.getRelation();
                return this.rewriteShowStats(node, table, (Constraint<ColumnHandle>)Constraint.alwaysTrue());
            }
            throw new IllegalArgumentException("Expected either TableSubquery or Table as relation");
        }

        private void validateShowStatsSubquery(ShowStats node, Query query, QuerySpecification querySpecification, Plan plan) {
            Optional filterNode = PlanNodeSearcher.searchFrom(plan.getRoot()).where(FilterNode.class::isInstance).findSingle();
            Visitor.check(!filterNode.isPresent(), node, "Only predicates that can be pushed down are supported in the SHOW STATS WHERE clause");
            Visitor.check(querySpecification.getFrom().isPresent(), node, "There must be exactly one table in query passed to SHOW STATS SELECT clause");
            Visitor.check(querySpecification.getFrom().get() instanceof Table, node, "There must be exactly one table in query passed to SHOW STATS SELECT clause");
            Visitor.check(!query.getWith().isPresent(), node, "WITH is not supported by SHOW STATS SELECT clause");
            Visitor.check(!querySpecification.getOrderBy().isPresent(), node, "ORDER BY is not supported in SHOW STATS SELECT clause");
            Visitor.check(!querySpecification.getLimit().isPresent(), node, "LIMIT is not supported by SHOW STATS SELECT clause");
            Visitor.check(!querySpecification.getHaving().isPresent(), node, "HAVING is not supported in SHOW STATS SELECT clause");
            Visitor.check(!querySpecification.getGroupBy().isPresent(), node, "GROUP BY is not supported in SHOW STATS SELECT clause");
            Visitor.check(!querySpecification.getSelect().isDistinct(), node, "DISTINCT is not supported by SHOW STATS SELECT clause");
            List selectItems = querySpecification.getSelect().getSelectItems();
            Visitor.check(selectItems.size() == 1 && selectItems.get(0) instanceof AllColumns, node, "Only SELECT * is supported in SHOW STATS SELECT clause");
        }

        private Node rewriteShowStats(ShowStats node, Table table, Constraint<ColumnHandle> constraint) {
            TableHandle tableHandle = this.getTableHandle(node, table.getName());
            TableStatistics tableStatistics = this.metadata.getTableStatistics(this.session, tableHandle, constraint);
            List<String> statsColumnNames = Visitor.buildColumnsNames();
            List<SelectItem> selectItems = Visitor.buildSelectItems(statsColumnNames);
            TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, tableHandle);
            Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, tableHandle);
            List<Expression> resultRows = this.buildStatisticsRows(tableMetadata, columnHandles, tableStatistics);
            return QueryUtil.simpleQuery((Select)QueryUtil.selectAll(selectItems), (Relation)QueryUtil.aliased((Relation)new Values(resultRows), (String)("table_stats_for_" + table.getName()), statsColumnNames));
        }

        private static void check(boolean condition, ShowStats node, String message) {
            if (!condition) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, message, new Object[0]);
            }
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }

        private Constraint<ColumnHandle> getConstraint(Plan plan) {
            Optional scanNode = PlanNodeSearcher.searchFrom(plan.getRoot()).where(TableScanNode.class::isInstance).findSingle();
            if (!scanNode.isPresent()) {
                return Constraint.alwaysFalse();
            }
            return new Constraint(((TableScanNode)scanNode.get()).getCurrentConstraint());
        }

        private TableHandle getTableHandle(ShowStats node, QualifiedName table) {
            QualifiedObjectName qualifiedTableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, table);
            return this.metadata.getTableHandle(this.session, qualifiedTableName).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)node, "Table %s not found", table));
        }

        private static List<String> buildColumnsNames() {
            return ImmutableList.builder().add((Object)"column_name").add((Object)"data_size").add((Object)"distinct_values_count").add((Object)"nulls_fraction").add((Object)"row_count").add((Object)"low_value").add((Object)"high_value").build();
        }

        private static List<SelectItem> buildSelectItems(List<String> columnNames) {
            return (List)columnNames.stream().map(QueryUtil::unaliasedName).collect(ImmutableList.toImmutableList());
        }

        private List<Expression> buildStatisticsRows(TableMetadata tableMetadata, Map<String, ColumnHandle> columnHandles, TableStatistics tableStatistics) {
            ImmutableList.Builder rowsBuilder = ImmutableList.builder();
            for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
                if (columnMetadata.isHidden()) continue;
                String columnName = columnMetadata.getName();
                Type columnType = columnMetadata.getType();
                ColumnHandle columnHandle = columnHandles.get(columnName);
                ColumnStatistics columnStatistics = (ColumnStatistics)tableStatistics.getColumnStatistics().get(columnHandle);
                if (columnStatistics != null) {
                    rowsBuilder.add((Object)this.createColumnStatsRow(columnName, columnType, columnStatistics));
                    continue;
                }
                rowsBuilder.add((Object)this.createEmptyColumnStatsRow(columnName));
            }
            rowsBuilder.add((Object)Visitor.createTableStatsRow(tableStatistics));
            return rowsBuilder.build();
        }

        private Row createColumnStatsRow(String columnName, Type type, ColumnStatistics columnStatistics) {
            ImmutableList.Builder rowValues = ImmutableList.builder();
            rowValues.add((Object)new StringLiteral(columnName));
            rowValues.add((Object)Visitor.createEstimateRepresentation(columnStatistics.getDataSize()));
            rowValues.add((Object)Visitor.createEstimateRepresentation(columnStatistics.getDistinctValuesCount()));
            rowValues.add((Object)Visitor.createEstimateRepresentation(columnStatistics.getNullsFraction()));
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)Visitor.toStringLiteral(type, columnStatistics.getRange().map(DoubleRange::getMin)));
            rowValues.add((Object)Visitor.toStringLiteral(type, columnStatistics.getRange().map(DoubleRange::getMax)));
            return new Row((List)rowValues.build());
        }

        private Expression createEmptyColumnStatsRow(String columnName) {
            ImmutableList.Builder rowValues = ImmutableList.builder();
            rowValues.add((Object)new StringLiteral(columnName));
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_VARCHAR);
            rowValues.add((Object)NULL_VARCHAR);
            return new Row((List)rowValues.build());
        }

        private static Row createTableStatsRow(TableStatistics tableStatistics) {
            ImmutableList.Builder rowValues = ImmutableList.builder();
            rowValues.add((Object)NULL_VARCHAR);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)NULL_DOUBLE);
            rowValues.add((Object)Visitor.createEstimateRepresentation(tableStatistics.getRowCount()));
            rowValues.add((Object)NULL_VARCHAR);
            rowValues.add((Object)NULL_VARCHAR);
            return new Row((List)rowValues.build());
        }

        private static Expression createEstimateRepresentation(Estimate estimate) {
            if (estimate.isUnknown()) {
                return NULL_DOUBLE;
            }
            return new DoubleLiteral(Double.toString(estimate.getValue()));
        }

        private static Expression toStringLiteral(Type type, Optional<Double> optionalValue) {
            return optionalValue.map(value -> Visitor.toStringLiteral(type, value)).orElse(NULL_VARCHAR);
        }

        private static Expression toStringLiteral(Type type, double value) {
            if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
                return new StringLiteral(Long.toString(Math.round(value)));
            }
            if (type.equals(DoubleType.DOUBLE) || type instanceof DecimalType) {
                return new StringLiteral(Double.toString(value));
            }
            if (type.equals(RealType.REAL)) {
                return new StringLiteral(Float.toString((float)value));
            }
            if (type.equals(DateType.DATE)) {
                return new StringLiteral(LocalDate.ofEpochDay(Math.round(value)).toString());
            }
            throw new IllegalArgumentException("Unexpected type: " + type);
        }
    }
}

