/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.InternalSignatureUtils;
import com.facebook.presto.metadata.OperatorSignatureUtils;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public final class Signatures {
    public static final String IF = "IF";
    public static final String NULL_IF = "NULL_IF";
    public static final String SWITCH = "SWITCH";
    public static final String CAST = OperatorSignatureUtils.mangleOperatorName("CAST");
    public static final String TRY_CAST = "TRY_CAST";
    public static final String IS_NULL = "IS_NULL";
    public static final String COALESCE = "COALESCE";
    public static final String IN = "IN";
    public static final String TRY = "TRY";
    public static final String DEREFERENCE = "DEREFERENCE";
    public static final String ROW_CONSTRUCTOR = "ROW_CONSTRUCTOR";
    public static final String BIND = "$INTERNAL$BIND";

    private Signatures() {
    }

    public static Signature notSignature() {
        return new Signature("not", FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"boolean"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"boolean")));
    }

    public static Signature betweenSignature(Type valueType, Type minType, Type maxType) {
        return InternalSignatureUtils.internalOperator("BETWEEN", TypeSignature.parseTypeSignature((String)"boolean"), valueType.getTypeSignature(), minType.getTypeSignature(), maxType.getTypeSignature());
    }

    public static Signature likeVarcharSignature() {
        return InternalSignatureUtils.internalScalarFunction("LIKE", TypeSignature.parseTypeSignature((String)"boolean"), TypeSignature.parseTypeSignature((String)"varchar"), TypeSignature.parseTypeSignature((String)"LikePattern"));
    }

    public static Signature likeCharSignature(Type valueType) {
        Preconditions.checkArgument((boolean)(valueType instanceof CharType), (Object)"Expected CHAR value type");
        return InternalSignatureUtils.internalScalarFunction("LIKE", TypeSignature.parseTypeSignature((String)"boolean"), valueType.getTypeSignature(), TypeSignature.parseTypeSignature((String)"LikePattern"));
    }

    public static Signature likePatternSignature() {
        return InternalSignatureUtils.internalScalarFunction("LIKE_PATTERN", TypeSignature.parseTypeSignature((String)"LikePattern"), TypeSignature.parseTypeSignature((String)"varchar"), TypeSignature.parseTypeSignature((String)"varchar"));
    }

    public static Signature castSignature(Type returnType, Type valueType) {
        return InternalSignatureUtils.internalScalarFunction(CAST, returnType.getTypeSignature(), valueType.getTypeSignature());
    }

    public static Signature tryCastSignature(Type returnType, Type valueType) {
        return InternalSignatureUtils.internalScalarFunction(TRY_CAST, returnType.getTypeSignature(), valueType.getTypeSignature());
    }

    public static Signature logicalExpressionSignature(LogicalBinaryExpression.Operator operator) {
        return InternalSignatureUtils.internalScalarFunction(operator.name(), TypeSignature.parseTypeSignature((String)"boolean"), TypeSignature.parseTypeSignature((String)"boolean"), TypeSignature.parseTypeSignature((String)"boolean"));
    }

    public static Signature arithmeticNegationSignature(Type returnType, Type valueType) {
        return InternalSignatureUtils.internalOperator("NEGATION", returnType.getTypeSignature(), valueType.getTypeSignature());
    }

    public static Signature arithmeticExpressionSignature(ArithmeticBinaryExpression.Operator operator, Type returnType, Type leftType, Type rightType) {
        return InternalSignatureUtils.internalOperator(operator.name(), returnType.getTypeSignature(), leftType.getTypeSignature(), rightType.getTypeSignature());
    }

    public static Signature subscriptSignature(Type returnType, Type leftType, Type rightType) {
        return InternalSignatureUtils.internalOperator(OperatorType.SUBSCRIPT.name(), returnType.getTypeSignature(), leftType.getTypeSignature(), rightType.getTypeSignature());
    }

    public static Signature arrayConstructorSignature(Type returnType, List<? extends Type> argumentTypes) {
        return InternalSignatureUtils.internalScalarFunction("ARRAY_CONSTRUCTOR", returnType.getTypeSignature(), Lists.transform(argumentTypes, Type::getTypeSignature));
    }

    public static Signature arrayConstructorSignature(TypeSignature returnType, List<TypeSignature> argumentTypes) {
        return InternalSignatureUtils.internalScalarFunction("ARRAY_CONSTRUCTOR", returnType, argumentTypes);
    }

    public static Signature comparisonExpressionSignature(ComparisonExpression.Operator operator, Type leftType, Type rightType) {
        for (OperatorType operatorType : OperatorType.values()) {
            if (!operatorType.name().equals(operator.name())) continue;
            return InternalSignatureUtils.internalOperator(operator.name(), TypeSignature.parseTypeSignature((String)"boolean"), leftType.getTypeSignature(), rightType.getTypeSignature());
        }
        return InternalSignatureUtils.internalScalarFunction(operator.name(), TypeSignature.parseTypeSignature((String)"boolean"), leftType.getTypeSignature(), rightType.getTypeSignature());
    }

    public static Signature ifSignature(Type returnType) {
        return new Signature(IF, FunctionKind.SCALAR, returnType.getTypeSignature(), new TypeSignature[0]);
    }

    public static Signature nullIfSignature(Type returnType, Type firstType, Type secondType) {
        return new Signature(NULL_IF, FunctionKind.SCALAR, returnType.getTypeSignature(), new TypeSignature[]{firstType.getTypeSignature(), secondType.getTypeSignature()});
    }

    public static Signature switchSignature(Type returnType) {
        return new Signature(SWITCH, FunctionKind.SCALAR, returnType.getTypeSignature(), new TypeSignature[0]);
    }

    public static Signature whenSignature(Type returnType) {
        return new Signature("WHEN", FunctionKind.SCALAR, returnType.getTypeSignature(), new TypeSignature[0]);
    }

    public static Signature trySignature(Type returnType) {
        return new Signature(TRY, FunctionKind.SCALAR, returnType.getTypeSignature(), new TypeSignature[0]);
    }

    public static Signature bindSignature(Type returnType, List<Type> valueTypes, Type functionType) {
        ImmutableList.Builder typeSignatureBuilder = ImmutableList.builder();
        for (Type valueType : valueTypes) {
            typeSignatureBuilder.add((Object)valueType.getTypeSignature());
        }
        typeSignatureBuilder.add((Object)functionType.getTypeSignature());
        return new Signature(BIND, FunctionKind.SCALAR, returnType.getTypeSignature(), (List)typeSignatureBuilder.build());
    }

    public static Signature inSignature() {
        return InternalSignatureUtils.internalScalarFunction(IN, TypeSignature.parseTypeSignature((String)"boolean"), new TypeSignature[0]);
    }

    public static Signature rowConstructorSignature(Type returnType, List<Type> argumentTypes) {
        return InternalSignatureUtils.internalScalarFunction(ROW_CONSTRUCTOR, returnType.getTypeSignature(), (List)argumentTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList()));
    }

    public static Signature isNullSignature(Type argumentType) {
        return InternalSignatureUtils.internalScalarFunction(IS_NULL, TypeSignature.parseTypeSignature((String)"boolean"), argumentType.getTypeSignature());
    }

    public static Signature coalesceSignature(Type returnType, List<Type> argumentTypes) {
        return InternalSignatureUtils.internalScalarFunction(COALESCE, returnType.getTypeSignature(), Lists.transform(argumentTypes, Type::getTypeSignature));
    }

    public static Signature dereferenceSignature(Type returnType, RowType rowType) {
        return InternalSignatureUtils.internalScalarFunction(DEREFERENCE, returnType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)rowType.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature()));
    }
}

