/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.VariableReferenceExpression;
import java.util.Objects;

public class DeterminismEvaluator {
    final FunctionManager functionManager;

    public DeterminismEvaluator(FunctionManager functionManager) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
    }

    public boolean isDeterministic(RowExpression expression) {
        return expression.accept(new Visitor(this.functionManager), null);
    }

    private static class Visitor
    implements RowExpressionVisitor<Boolean, Void> {
        private final FunctionManager functionManager;

        public Visitor(FunctionManager functionManager) {
            this.functionManager = functionManager;
        }

        @Override
        public Boolean visitInputReference(InputReferenceExpression reference, Void context) {
            return true;
        }

        @Override
        public Boolean visitConstant(ConstantExpression literal, Void context) {
            return true;
        }

        @Override
        public Boolean visitCall(CallExpression call, Void context) {
            Signature signature = call.getSignature();
            if (this.functionManager.isRegistered(signature) && !this.functionManager.getScalarFunctionImplementation(signature).isDeterministic()) {
                return false;
            }
            return call.getArguments().stream().allMatch(expression -> expression.accept(this, context));
        }

        @Override
        public Boolean visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return lambda.getBody().accept(this, context);
        }

        @Override
        public Boolean visitVariableReference(VariableReferenceExpression reference, Void context) {
            return true;
        }
    }
}

