/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.ActualProperties;
import com.facebook.presto.sql.planner.optimizations.PropertyDerivations;
import com.facebook.presto.sql.planner.optimizations.StreamPropertyDerivations;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.sanity.PlanSanityChecker;
import com.facebook.presto.util.Optionals;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ValidateAggregationsWithDefaultValues
implements PlanSanityChecker.Checker {
    private final boolean forceSingleNode;

    public ValidateAggregationsWithDefaultValues(boolean forceSingleNode) {
        this.forceSingleNode = forceSingleNode;
    }

    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        planNode.accept(new Visitor(session, metadata, sqlParser, types), null);
    }

    private static class SeenExchanges {
        final boolean localRepartitionExchange;
        final boolean remoteRepartitionExchange;

        SeenExchanges(boolean localRepartitionExchange, boolean remoteRepartitionExchange) {
            this.localRepartitionExchange = localRepartitionExchange;
            this.remoteRepartitionExchange = remoteRepartitionExchange;
        }
    }

    private class Visitor
    extends PlanVisitor<Optional<SeenExchanges>, Void> {
        final Session session;
        final Metadata metadata;
        final SqlParser parser;
        final TypeProvider types;

        Visitor(Session session, Metadata metadata, SqlParser parser, TypeProvider types) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.parser = Objects.requireNonNull(parser, "parser is null");
            this.types = Objects.requireNonNull(types, "types is null");
        }

        @Override
        protected Optional<SeenExchanges> visitPlan(PlanNode node, Void context) {
            return this.aggregatedSeenExchanges(node.getSources());
        }

        @Override
        public Optional<SeenExchanges> visitAggregation(AggregationNode node, Void context) {
            Optional<SeenExchanges> seenExchangesOptional = this.aggregatedSeenExchanges(node.getSources());
            if (node.getStep().equals((Object)AggregationNode.Step.PARTIAL)) {
                return Optional.of(new SeenExchanges(false, false));
            }
            if (node.getStep().equals((Object)AggregationNode.Step.INTERMEDIATE)) {
                return seenExchangesOptional;
            }
            if (!node.getStep().equals((Object)AggregationNode.Step.FINAL) || !node.hasEmptyGroupingSet()) {
                return Optional.empty();
            }
            Preconditions.checkState((boolean)seenExchangesOptional.isPresent(), (Object)"No partial aggregation below final aggregation");
            SeenExchanges seenExchanges = seenExchangesOptional.get();
            if (seenExchanges.remoteRepartitionExchange) {
                return Optional.empty();
            }
            ActualProperties globalProperties = PropertyDerivations.derivePropertiesRecursively(node, this.metadata, this.session, this.types, this.parser);
            Preconditions.checkArgument((ValidateAggregationsWithDefaultValues.this.forceSingleNode || globalProperties.isSingleNode() ? 1 : 0) != 0, (Object)"Final aggregation with default value not separated from partial aggregation by remote hash exchange");
            if (!seenExchanges.localRepartitionExchange) {
                StreamPropertyDerivations.StreamProperties localProperties = StreamPropertyDerivations.derivePropertiesRecursively(node, this.metadata, this.session, this.types, this.parser);
                Preconditions.checkArgument((boolean)localProperties.isSingleStream(), (Object)"Final aggregation with default value not separated from partial aggregation by local hash exchange");
            }
            return Optional.empty();
        }

        @Override
        public Optional<SeenExchanges> visitExchange(ExchangeNode node, Void context) {
            Optional<SeenExchanges> seenExchangesOptional = this.aggregatedSeenExchanges(node.getSources());
            if (!seenExchangesOptional.isPresent()) {
                return Optional.empty();
            }
            if (!node.getType().equals((Object)ExchangeNode.Type.REPARTITION)) {
                return seenExchangesOptional;
            }
            SeenExchanges seenExchanges = seenExchangesOptional.get();
            if (node.getScope().equals((Object)ExchangeNode.Scope.REMOTE)) {
                return Optional.of(new SeenExchanges(false, true));
            }
            return Optional.of(new SeenExchanges(true, seenExchanges.remoteRepartitionExchange));
        }

        private Optional<SeenExchanges> aggregatedSeenExchanges(List<PlanNode> nodes) {
            return nodes.stream().map(source -> source.accept(this, null)).reduce((accumulatorOptional, seenExchangesOptional) -> Optionals.combine(accumulatorOptional, seenExchangesOptional, (accumulator, seenExchanges) -> new SeenExchanges(accumulator.localRepartitionExchange && seenExchanges.localRepartitionExchange, accumulator.remoteRepartitionExchange && seenExchanges.remoteRepartitionExchange))).orElse(Optional.empty());
        }
    }
}

