/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.sanity.PlanSanityChecker;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TypeValidator
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        plan.accept(new Visitor(session, metadata, sqlParser, types, warningCollector), null);
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final Session session;
        private final Metadata metadata;
        private final SqlParser sqlParser;
        private final TypeProvider types;
        private final WarningCollector warningCollector;

        public Visitor(Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            AggregationNode.Step step = node.getStep();
            switch (step) {
                case SINGLE: {
                    this.checkFunctionSignature(node.getAggregations());
                    this.checkFunctionCall(node.getAggregations());
                    break;
                }
                case FINAL: {
                    this.checkFunctionSignature(node.getAggregations());
                }
            }
            return null;
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            this.checkWindowFunctions(node.getWindowFunctions());
            return null;
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
                Type expectedType = this.types.get(entry.getKey());
                if (entry.getValue() instanceof SymbolReference) {
                    SymbolReference symbolReference = (SymbolReference)entry.getValue();
                    this.verifyTypeSignature(entry.getKey(), expectedType.getTypeSignature(), this.types.get(Symbol.from((Expression)symbolReference)).getTypeSignature());
                    continue;
                }
                Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.types, entry.getValue(), Collections.emptyList(), this.warningCollector);
                Type actualType = expressionTypes.get(NodeRef.of((Node)((Node)entry.getValue())));
                this.verifyTypeSignature(entry.getKey(), expectedType.getTypeSignature(), actualType.getTypeSignature());
            }
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            ListMultimap<Symbol, Symbol> symbolMapping = node.getSymbolMapping();
            for (Symbol keySymbol : symbolMapping.keySet()) {
                List valueSymbols = symbolMapping.get((Object)keySymbol);
                Type expectedType = this.types.get(keySymbol);
                for (Symbol valueSymbol : valueSymbols) {
                    this.verifyTypeSignature(keySymbol, expectedType.getTypeSignature(), this.types.get(valueSymbol).getTypeSignature());
                }
            }
            return null;
        }

        private void checkWindowFunctions(Map<Symbol, WindowNode.Function> functions) {
            for (Map.Entry<Symbol, WindowNode.Function> entry : functions.entrySet()) {
                Signature signature = entry.getValue().getFunctionHandle().getSignature();
                FunctionCall call = entry.getValue().getFunctionCall();
                this.checkSignature(entry.getKey(), signature);
                this.checkCall(entry.getKey(), call);
            }
        }

        private void checkSignature(Symbol symbol, Signature signature) {
            TypeSignature expectedTypeSignature = this.types.get(symbol).getTypeSignature();
            TypeSignature actualTypeSignature = signature.getReturnType();
            this.verifyTypeSignature(symbol, expectedTypeSignature, actualTypeSignature);
        }

        private void checkCall(Symbol symbol, FunctionCall call) {
            Type expectedType = this.types.get(symbol);
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.types, (Expression)call, Collections.emptyList(), this.warningCollector);
            Type actualType = expressionTypes.get(NodeRef.of((Node)call));
            this.verifyTypeSignature(symbol, expectedType.getTypeSignature(), actualType.getTypeSignature());
        }

        private void checkFunctionSignature(Map<Symbol, AggregationNode.Aggregation> aggregations) {
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
                this.checkSignature(entry.getKey(), entry.getValue().getFunctionHandle().getSignature());
            }
        }

        private void checkFunctionCall(Map<Symbol, AggregationNode.Aggregation> aggregations) {
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : aggregations.entrySet()) {
                this.checkCall(entry.getKey(), entry.getValue().getCall());
            }
        }

        private void verifyTypeSignature(Symbol symbol, TypeSignature expected, TypeSignature actual) {
            TypeManager typeManager = this.metadata.getTypeManager();
            if (!actual.equals((Object)UnknownType.UNKNOWN.getTypeSignature()) && !typeManager.isTypeOnlyCoercion(typeManager.getType(actual), typeManager.getType(expected))) {
                Preconditions.checkArgument((boolean)expected.equals((Object)actual), (String)"type of symbol '%s' is expected to be %s, but the actual type is %s", (Object)symbol, (Object)expected, (Object)actual);
            }
        }
    }
}

