/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.AnalyzeTableHandle;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.StatisticAggregationsDescriptor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;

public class StatisticsWriterNode
extends PlanNode {
    private final PlanNode source;
    private final Symbol rowCountSymbol;
    private final WriteStatisticsTarget target;
    private final boolean rowCountEnabled;
    private final StatisticAggregationsDescriptor<Symbol> descriptor;

    @JsonCreator
    public StatisticsWriterNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") WriteStatisticsTarget target, @JsonProperty(value="rowCountSymbol") Symbol rowCountSymbol, @JsonProperty(value="rowCountEnabled") boolean rowCountEnabled, @JsonProperty(value="descriptor") StatisticAggregationsDescriptor<Symbol> descriptor) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.rowCountSymbol = Objects.requireNonNull(rowCountSymbol, "rowCountSymbol is null");
        this.rowCountEnabled = rowCountEnabled;
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public WriteStatisticsTarget getTarget() {
        return this.target;
    }

    @JsonProperty
    public StatisticAggregationsDescriptor<Symbol> getDescriptor() {
        return this.descriptor;
    }

    @JsonProperty
    public Symbol getRowCountSymbol() {
        return this.rowCountSymbol;
    }

    @JsonProperty
    public boolean isRowCountEnabled() {
        return this.rowCountEnabled;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.of((Object)this.rowCountSymbol);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new StatisticsWriterNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.target, this.rowCountSymbol, this.rowCountEnabled, this.descriptor);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitStatisticsWriterNode(this, context);
    }

    public static class WriteStatisticsReference
    extends WriteStatisticsTarget {
        private final TableHandle handle;

        public WriteStatisticsReference(TableHandle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        public TableHandle getHandle() {
            return this.handle;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class WriteStatisticsHandle
    extends WriteStatisticsTarget {
        private final AnalyzeTableHandle handle;

        @JsonCreator
        public WriteStatisticsHandle(@JsonProperty(value="handle") AnalyzeTableHandle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        @JsonProperty
        public AnalyzeTableHandle getHandle() {
            return this.handle;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=WriteStatisticsHandle.class, name="WriteStatisticsHandle")})
    public static abstract class WriteStatisticsTarget {
        public abstract String toString();
    }
}

