/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExplainAnalyzeNode
extends PlanNode {
    private final PlanNode source;
    private final Symbol outputSymbol;
    private final boolean verbose;

    @JsonCreator
    public ExplainAnalyzeNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="outputSymbol") Symbol outputSymbol, @JsonProperty(value="verbose") boolean verbose) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.outputSymbol = Objects.requireNonNull(outputSymbol, "outputSymbol is null");
        this.verbose = verbose;
    }

    @JsonProperty(value="outputSymbol")
    public Symbol getOutputSymbol() {
        return this.outputSymbol;
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty(value="verbose")
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.of((Object)this.outputSymbol);
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitExplainAnalyze(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new ExplainAnalyzeNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.outputSymbol, this.isVerbose());
    }
}

