/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.PlanNodeDecorrelator;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransformExistsApplyToLateralNode
implements Rule<ApplyNode> {
    private static final Pattern<ApplyNode> PATTERN = Patterns.applyNode();
    private static final QualifiedName COUNT = QualifiedName.of((String)"count");
    private static final FunctionCall COUNT_CALL = new FunctionCall(COUNT, (List)ImmutableList.of());
    private final FunctionManager functionManager;

    public TransformExistsApplyToLateralNode(FunctionManager functionManager) {
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
    }

    @Override
    public Pattern<ApplyNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ApplyNode parent, Captures captures, Rule.Context context) {
        if (parent.getSubqueryAssignments().size() != 1) {
            return Rule.Result.empty();
        }
        Expression expression = (Expression)Iterables.getOnlyElement(parent.getSubqueryAssignments().getExpressions());
        if (!(expression instanceof ExistsPredicate)) {
            return Rule.Result.empty();
        }
        Optional<PlanNode> nonDefaultAggregation = this.rewriteToNonDefaultAggregation(parent, context);
        return nonDefaultAggregation.map(Rule.Result::ofPlanNode).orElseGet(() -> Rule.Result.ofPlanNode(this.rewriteToDefaultAggregation(parent, context)));
    }

    private Optional<PlanNode> rewriteToNonDefaultAggregation(ApplyNode applyNode, Rule.Context context) {
        Preconditions.checkState((boolean)applyNode.getSubquery().getOutputSymbols().isEmpty(), (Object)"Expected subquery output symbols to be pruned");
        Symbol exists = (Symbol)Iterables.getOnlyElement(applyNode.getSubqueryAssignments().getSymbols());
        Symbol subqueryTrue = context.getSymbolAllocator().newSymbol("subqueryTrue", (Type)BooleanType.BOOLEAN);
        Assignments.Builder assignments = Assignments.builder();
        assignments.putIdentities(applyNode.getInput().getOutputSymbols());
        assignments.put(exists, (Expression)new CoalesceExpression((List)ImmutableList.of((Object)subqueryTrue.toSymbolReference(), (Object)BooleanLiteral.FALSE_LITERAL)));
        ProjectNode subquery = new ProjectNode(context.getIdAllocator().getNextId(), new LimitNode(context.getIdAllocator().getNextId(), applyNode.getSubquery(), 1L, false), Assignments.of(subqueryTrue, (Expression)BooleanLiteral.TRUE_LITERAL));
        PlanNodeDecorrelator decorrelator = new PlanNodeDecorrelator(context.getIdAllocator(), context.getLookup());
        if (!decorrelator.decorrelateFilters(subquery, applyNode.getCorrelation()).isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new ProjectNode(context.getIdAllocator().getNextId(), new LateralJoinNode(applyNode.getId(), applyNode.getInput(), subquery, applyNode.getCorrelation(), LateralJoinNode.Type.LEFT, applyNode.getOriginSubquery()), assignments.build()));
    }

    private PlanNode rewriteToDefaultAggregation(ApplyNode parent, Rule.Context context) {
        Symbol count = context.getSymbolAllocator().newSymbol(COUNT.toString(), (Type)BigintType.BIGINT);
        Symbol exists = (Symbol)Iterables.getOnlyElement(parent.getSubqueryAssignments().getSymbols());
        return new LateralJoinNode(parent.getId(), parent.getInput(), new ProjectNode(context.getIdAllocator().getNextId(), new AggregationNode(context.getIdAllocator().getNextId(), parent.getSubquery(), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of((Object)count, (Object)new AggregationNode.Aggregation(COUNT_CALL, this.functionManager.resolveFunction(context.getSession(), COUNT, (List<TypeSignatureProvider>)ImmutableList.of()), Optional.empty())), AggregationNode.globalAggregation(), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty()), Assignments.of(exists, (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)count.toSymbolReference(), (Expression)new Cast((Expression)new LongLiteral("0"), BigintType.BIGINT.toString())))), parent.getCorrelation(), LateralJoinNode.Type.INNER, parent.getOriginSubquery());
    }
}

