/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RewriteSpatialPartitioningAggregation
implements Rule<AggregationNode> {
    private static final TypeSignature GEOMETRY_TYPE_SIGNATURE = TypeSignature.parseTypeSignature((String)"Geometry");
    private static final String NAME = "spatial_partitioning";
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().matching(RewriteSpatialPartitioningAggregation::hasSpatialPartitioningAggregation);
    private final Metadata metadata;

    public RewriteSpatialPartitioningAggregation(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    private static boolean hasSpatialPartitioningAggregation(AggregationNode aggregation) {
        return aggregation.getAggregations().values().stream().map(AggregationNode.Aggregation::getCall).anyMatch(call -> call.getName().toString().equals(NAME) && call.getArguments().size() == 1);
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        Symbol partitionCountSymbol = context.getSymbolAllocator().newSymbol("partition_count", (Type)IntegerType.INTEGER);
        ImmutableMap.Builder envelopeAssignments = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
            AggregationNode.Aggregation aggregation = entry.getValue();
            FunctionCall call = aggregation.getCall();
            QualifiedName name = call.getName();
            Type geometryType = this.metadata.getType(GEOMETRY_TYPE_SIGNATURE);
            if (name.toString().equals(NAME) && call.getArguments().size() == 1) {
                Expression geometry = (Expression)Iterables.getOnlyElement((Iterable)call.getArguments());
                Symbol envelopeSymbol = context.getSymbolAllocator().newSymbol("envelope", geometryType);
                if (geometry instanceof FunctionCall && ((FunctionCall)geometry).getName().toString().equalsIgnoreCase("ST_Envelope")) {
                    envelopeAssignments.put((Object)envelopeSymbol, (Object)geometry);
                } else {
                    envelopeAssignments.put((Object)envelopeSymbol, (Object)new FunctionCall(QualifiedName.of((String)"ST_Envelope"), (List)ImmutableList.of((Object)geometry)));
                }
                aggregations.put((Object)entry.getKey(), (Object)new AggregationNode.Aggregation(new FunctionCall(name, (List)ImmutableList.of((Object)envelopeSymbol.toSymbolReference(), (Object)partitionCountSymbol.toSymbolReference())), this.metadata.getFunctionManager().resolveFunction(context.getSession(), QualifiedName.of((String)NAME), TypeSignatureProvider.fromTypes(new Type[]{geometryType, IntegerType.INTEGER})), aggregation.getMask()));
                continue;
            }
            aggregations.put(entry);
        }
        return Rule.Result.ofPlanNode(new AggregationNode(node.getId(), new ProjectNode(context.getIdAllocator().getNextId(), node.getSource(), Assignments.builder().putIdentities(node.getSource().getOutputSymbols()).put(partitionCountSymbol, (Expression)new LongLiteral(Integer.toString(SystemSessionProperties.getHashPartitionCount(context.getSession())))).putAll((Map<Symbol, Expression>)envelopeAssignments.build()).build()), (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), node.getGroupingSets(), node.getPreGroupedSymbols(), node.getStep(), node.getHashSymbol(), node.getGroupIdSymbol()));
    }
}

