/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.util.List;

public class PushLimitThroughOuterJoin
implements Rule<LimitNode> {
    private static final Capture<JoinNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.join().with(Patterns.Join.type().matching(type -> PushLimitThroughOuterJoin.isLeftOrFullOuter(type) || PushLimitThroughOuterJoin.isRightOrFullOuter(type))).capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        JoinNode joinNode = (JoinNode)captures.get(CHILD);
        PlanNode left = joinNode.getLeft();
        PlanNode right = joinNode.getRight();
        if (PushLimitThroughOuterJoin.isLeftOrFullOuter(joinNode.getType()) && !PushLimitThroughOuterJoin.isLimited(left, context.getLookup(), parent.getCount())) {
            left = new LimitNode(context.getIdAllocator().getNextId(), left, parent.getCount(), true);
        }
        if (PushLimitThroughOuterJoin.isRightOrFullOuter(joinNode.getType()) && !PushLimitThroughOuterJoin.isLimited(right, context.getLookup(), parent.getCount())) {
            right = new LimitNode(context.getIdAllocator().getNextId(), right, parent.getCount(), true);
        }
        if (joinNode.getLeft() != left || joinNode.getRight() != right) {
            return Rule.Result.ofPlanNode(parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)joinNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)left, (Object)right)))));
        }
        return Rule.Result.empty();
    }

    private static boolean isLimited(PlanNode node, Lookup lookup, long limit) {
        Range<Long> cardinality = QueryCardinalityUtil.extractCardinality(node, lookup);
        return cardinality.hasUpperBound() && (Long)cardinality.upperEndpoint() <= limit;
    }

    private static boolean isLeftOrFullOuter(JoinNode.Type type) {
        return type == JoinNode.Type.LEFT || type == JoinNode.Type.FULL;
    }

    private static boolean isRightOrFullOuter(JoinNode.Type type) {
        return type == JoinNode.Type.RIGHT || type == JoinNode.Type.FULL;
    }
}

