/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PruneCountAggregationOverScalar
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode parent, Captures captures, Rule.Context context) {
        if (!parent.hasDefaultOutput() || parent.getOutputSymbols().size() != 1) {
            return Rule.Result.empty();
        }
        Map<Symbol, AggregationNode.Aggregation> assignments = parent.getAggregations();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : assignments.entrySet()) {
            AggregationNode.Aggregation aggregation = entry.getValue();
            Objects.requireNonNull(aggregation, "aggregation is null");
            FunctionCall functionCall = aggregation.getCall();
            if ("count".equals(functionCall.getName().getSuffix()) && functionCall.getArguments().isEmpty()) continue;
            return Rule.Result.empty();
        }
        if (!assignments.isEmpty() && QueryCardinalityUtil.isScalar(parent.getSource(), context.getLookup())) {
            return Rule.Result.ofPlanNode(new ValuesNode(parent.getId(), parent.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1")))));
        }
        return Rule.Result.empty();
    }
}

