/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.PlanNode;
import java.util.Objects;

public final class PreconditionRules {
    private PreconditionRules() {
    }

    public static Rule<ExchangeNode> checkRulesAreFiredBeforeAddExchangesRule() {
        return PreconditionRules.checkNoPlanNodeMatches(Patterns.exchange(), "Expected rules to be fired before 'AddExchanges' optimizer");
    }

    private static <T extends PlanNode> Rule<T> checkNoPlanNodeMatches(Pattern<T> pattern, String message) {
        return new CheckNoPlanNodeMatchesRule<T>(pattern, message);
    }

    private static class CheckNoPlanNodeMatchesRule<T extends PlanNode>
    implements Rule<T> {
        private final Pattern<T> pattern;
        private final String message;

        public CheckNoPlanNodeMatchesRule(Pattern<T> pattern, String message) {
            this.pattern = Objects.requireNonNull(pattern, "pattern is null");
            this.message = Objects.requireNonNull(message, "message is null");
        }

        @Override
        public Pattern<T> getPattern() {
            return this.pattern;
        }

        @Override
        public Rule.Result apply(T node, Captures captures, Rule.Context context) {
            throw new IllegalStateException(this.message);
        }
    }
}

