/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.ConstantPageProjection;
import com.facebook.presto.operator.project.GeneratedPageProjection;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.InputPageProjection;
import com.facebook.presto.operator.project.PageFieldsToInputParametersRewriter;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CacheStatsMBean;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.InputReferenceCompiler;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.gen.LambdaExpressionExtractor;
import com.facebook.presto.sql.gen.RowExpressionCompiler;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.DeterminismEvaluator;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.util.CompilerUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.ForLoop;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class PageFunctionCompiler {
    private final Metadata metadata;
    private final DeterminismEvaluator determinismEvaluator;
    private final LoadingCache<RowExpression, Supplier<PageProjection>> projectionCache;
    private final LoadingCache<RowExpression, Supplier<PageFilter>> filterCache;
    private final CacheStatsMBean projectionCacheStats;
    private final CacheStatsMBean filterCacheStats;

    @Inject
    public PageFunctionCompiler(Metadata metadata, CompilerConfig config) {
        this(metadata, Objects.requireNonNull(config, "config is null").getExpressionCacheSize());
    }

    public PageFunctionCompiler(Metadata metadata, int expressionCacheSize) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.determinismEvaluator = new DeterminismEvaluator(metadata.getFunctionManager());
        if (expressionCacheSize > 0) {
            this.projectionCache = CacheBuilder.newBuilder().recordStats().maximumSize((long)expressionCacheSize).build(CacheLoader.from(projection -> this.compileProjectionInternal((RowExpression)projection, Optional.empty())));
            this.projectionCacheStats = new CacheStatsMBean(this.projectionCache);
        } else {
            this.projectionCache = null;
            this.projectionCacheStats = null;
        }
        if (expressionCacheSize > 0) {
            this.filterCache = CacheBuilder.newBuilder().recordStats().maximumSize((long)expressionCacheSize).build(CacheLoader.from(filter -> this.compileFilterInternal((RowExpression)filter, Optional.empty())));
            this.filterCacheStats = new CacheStatsMBean(this.filterCache);
        } else {
            this.filterCache = null;
            this.filterCacheStats = null;
        }
    }

    @Nullable
    @Managed
    @Nested
    public CacheStatsMBean getProjectionCache() {
        return this.projectionCacheStats;
    }

    @Nullable
    @Managed
    @Nested
    public CacheStatsMBean getFilterCache() {
        return this.filterCacheStats;
    }

    public Supplier<PageProjection> compileProjection(RowExpression projection, Optional<String> classNameSuffix) {
        if (this.projectionCache == null) {
            return this.compileProjectionInternal(projection, classNameSuffix);
        }
        return (Supplier)this.projectionCache.getUnchecked((Object)projection);
    }

    private Supplier<PageProjection> compileProjectionInternal(RowExpression projection, Optional<String> classNameSuffix) {
        Class<Work> pageProjectionWorkClass;
        Objects.requireNonNull(projection, "projection is null");
        if (projection instanceof InputReferenceExpression) {
            InputReferenceExpression input = (InputReferenceExpression)projection;
            InputPageProjection projectionFunction = new InputPageProjection(input.getField(), input.getType());
            return () -> projectionFunction;
        }
        if (projection instanceof ConstantExpression) {
            ConstantExpression constant = (ConstantExpression)projection;
            ConstantPageProjection projectionFunction = new ConstantPageProjection(constant.getValue(), constant.getType());
            return () -> projectionFunction;
        }
        PageFieldsToInputParametersRewriter.Result result = PageFieldsToInputParametersRewriter.rewritePageFieldsToInputParameters(projection);
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition pageProjectionWorkDefinition = this.definePageProjectWorkClass(result.getRewrittenExpression(), callSiteBinder, classNameSuffix);
        try {
            pageProjectionWorkClass = CompilerUtils.defineClass(pageProjectionWorkDefinition, Work.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, (Throwable)e);
        }
        return () -> new GeneratedPageProjection(result.getRewrittenExpression(), this.determinismEvaluator.isDeterministic(result.getRewrittenExpression()), result.getInputChannels(), Reflection.constructorMethodHandle(pageProjectionWorkClass, BlockBuilder.class, ConnectorSession.class, Page.class, SelectedPositions.class));
    }

    private static ParameterizedType generateProjectionWorkClassName(Optional<String> classNameSuffix) {
        return CompilerUtils.makeClassName("PageProjectionWork", classNameSuffix);
    }

    private ClassDefinition definePageProjectWorkClass(RowExpression projection, CallSiteBinder callSiteBinder, Optional<String> classNameSuffix) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), PageFunctionCompiler.generateProjectionWorkClassName(classNameSuffix), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(Work.class)});
        FieldDefinition blockBuilderField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "blockBuilder", BlockBuilder.class);
        FieldDefinition sessionField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "session", ConnectorSession.class);
        FieldDefinition pageField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "page", Page.class);
        FieldDefinition selectedPositionsField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "selectedPositions", SelectedPositions.class);
        FieldDefinition nextIndexOrPositionField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "nextIndexOrPosition", Integer.TYPE);
        FieldDefinition resultField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "result", Block.class);
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        PageFunctionCompiler.generateProcessMethod(classDefinition, blockBuilderField, sessionField, pageField, selectedPositionsField, nextIndexOrPositionField, resultField);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getResult", ParameterizedType.type(Object.class), (Iterable)ImmutableList.of());
        method.getBody().append((BytecodeNode)method.getThis().getField(resultField)).ret(Object.class);
        Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap = this.generateMethodsForLambda(classDefinition, callSiteBinder, cachedInstanceBinder, projection);
        this.generateEvaluateMethod(classDefinition, callSiteBinder, cachedInstanceBinder, compiledLambdaMap, projection, blockBuilderField);
        Parameter blockBuilder = Parameter.arg((String)"blockBuilder", BlockBuilder.class);
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter selectedPositions = Parameter.arg((String)"selectedPositions", SelectedPositions.class);
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{blockBuilder, session, page, selectedPositions});
        BytecodeBlock body = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]).append((BytecodeNode)thisVariable.setField(blockBuilderField, (BytecodeExpression)blockBuilder)).append((BytecodeNode)thisVariable.setField(sessionField, (BytecodeExpression)session)).append((BytecodeNode)thisVariable.setField(pageField, (BytecodeExpression)page)).append((BytecodeNode)thisVariable.setField(selectedPositionsField, (BytecodeExpression)selectedPositions)).append((BytecodeNode)thisVariable.setField(nextIndexOrPositionField, selectedPositions.invoke("getOffset", Integer.TYPE, new BytecodeExpression[0]))).append((BytecodeNode)thisVariable.setField(resultField, BytecodeExpressions.constantNull(Block.class)));
        cachedInstanceBinder.generateInitializations(thisVariable, body);
        body.ret();
        return classDefinition;
    }

    private static MethodDefinition generateProcessMethod(ClassDefinition classDefinition, FieldDefinition blockBuilder, FieldDefinition session, FieldDefinition page, FieldDefinition selectedPositions, FieldDefinition nextIndexOrPosition, FieldDefinition result) {
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "process", ParameterizedType.type(Boolean.TYPE), (Iterable)ImmutableList.of());
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody();
        Variable from = scope.declareVariable("from", body, thisVariable.getField(nextIndexOrPosition));
        Variable to = scope.declareVariable("to", body, BytecodeExpressions.add((BytecodeExpression)thisVariable.getField(selectedPositions).invoke("getOffset", Integer.TYPE, new BytecodeExpression[0]), (BytecodeExpression)thisVariable.getField(selectedPositions).invoke("size", Integer.TYPE, new BytecodeExpression[0])));
        Variable positions = scope.declareVariable(int[].class, "positions");
        Variable index = scope.declareVariable(Integer.TYPE, "index");
        IfStatement ifStatement = new IfStatement().condition((BytecodeNode)thisVariable.getField(selectedPositions).invoke("isList", Boolean.TYPE, new BytecodeExpression[0]));
        body.append((BytecodeNode)ifStatement);
        ifStatement.ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)positions.set(thisVariable.getField(selectedPositions).invoke("getPositions", int[].class, new BytecodeExpression[0]))).append((BytecodeNode)new ForLoop("positions loop", new Object[0]).initialize((BytecodeNode)index.set((BytecodeExpression)from)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)index, (BytecodeExpression)to)).update((BytecodeNode)index.increment()).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)thisVariable.invoke("evaluate", Void.TYPE, new BytecodeExpression[]{thisVariable.getField(session), thisVariable.getField(page), positions.getElement((BytecodeExpression)index)})))));
        ifStatement.ifFalse((BytecodeNode)new ForLoop("range based loop", new Object[0]).initialize((BytecodeNode)index.set((BytecodeExpression)from)).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)index, (BytecodeExpression)to)).update((BytecodeNode)index.increment()).body((BytecodeNode)new BytecodeBlock().append((BytecodeNode)thisVariable.invoke("evaluate", Void.TYPE, new BytecodeExpression[]{thisVariable.getField(session), thisVariable.getField(page), index}))));
        body.comment("result = this.blockBuilder.build(); return true;").append((BytecodeNode)thisVariable.setField(result, thisVariable.getField(blockBuilder).invoke("build", Block.class, new BytecodeExpression[0]))).push(true).retBoolean();
        return method;
    }

    private MethodDefinition generateEvaluateMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap, RowExpression projection, FieldDefinition blockBuilder) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "evaluate", ParameterizedType.type(Void.TYPE), (Iterable)ImmutableList.builder().add((Object)session).add((Object)page).add((Object)position).build());
        method.comment("Projection: %s", new Object[]{projection.toString()});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable thisVariable = method.getThis();
        PageFunctionCompiler.declareBlockVariables(projection, page, scope, body);
        scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        RowExpressionCompiler compiler = new RowExpressionCompiler(callSiteBinder, cachedInstanceBinder, PageFunctionCompiler.fieldReferenceCompiler(callSiteBinder), this.metadata.getFunctionManager(), compiledLambdaMap);
        Variable outputBlockVariable = scope.createTempVariable(BlockBuilder.class);
        body.append((BytecodeNode)outputBlockVariable.set(thisVariable.getField(blockBuilder))).append(compiler.compile(projection, scope, Optional.of(outputBlockVariable))).ret();
        return method;
    }

    public Supplier<PageFilter> compileFilter(RowExpression filter, Optional<String> classNameSuffix) {
        if (this.filterCache == null) {
            return this.compileFilterInternal(filter, classNameSuffix);
        }
        return (Supplier)this.filterCache.getUnchecked((Object)filter);
    }

    private Supplier<PageFilter> compileFilterInternal(RowExpression filter, Optional<String> classNameSuffix) {
        Class<PageFilter> functionClass;
        Objects.requireNonNull(filter, "filter is null");
        PageFieldsToInputParametersRewriter.Result result = PageFieldsToInputParametersRewriter.rewritePageFieldsToInputParameters(filter);
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = this.defineFilterClass(result.getRewrittenExpression(), result.getInputChannels(), callSiteBinder, classNameSuffix);
        try {
            functionClass = CompilerUtils.defineClass(classDefinition, PageFilter.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, filter.toString(), e.getCause());
        }
        return () -> {
            try {
                return (PageFilter)functionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, (Throwable)e);
            }
        };
    }

    private static ParameterizedType generateFilterClassName(Optional<String> classNameSuffix) {
        return CompilerUtils.makeClassName(PageFilter.class.getSimpleName(), classNameSuffix);
    }

    private ClassDefinition defineFilterClass(RowExpression filter, InputChannels inputChannels, CallSiteBinder callSiteBinder, Optional<String> classNameSuffix) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), PageFunctionCompiler.generateFilterClassName(classNameSuffix), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(PageFilter.class)});
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap = this.generateMethodsForLambda(classDefinition, callSiteBinder, cachedInstanceBinder, filter);
        this.generateFilterMethod(classDefinition, callSiteBinder, cachedInstanceBinder, compiledLambdaMap, filter);
        FieldDefinition selectedPositions = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), "selectedPositions", boolean[].class);
        PageFunctionCompiler.generatePageFilterMethod(classDefinition, selectedPositions);
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "isDeterministic", ParameterizedType.type(Boolean.TYPE), new Parameter[0]).getBody().append((BytecodeNode)BytecodeExpressions.constantBoolean((boolean)this.determinismEvaluator.isDeterministic(filter))).retBoolean();
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getInputChannels", ParameterizedType.type(InputChannels.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(inputChannels, InputChannels.class), "getInputChannels")).retObject();
        String toStringResult = MoreObjects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filter).toString();
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "toString", ParameterizedType.type(String.class), new Parameter[0]).getBody().append((BytecodeNode)BytecodeUtils.invoke(callSiteBinder.bind(toStringResult, String.class), "toString")).retObject();
        PageFunctionCompiler.generateConstructor(classDefinition, cachedInstanceBinder, compiledLambdaMap, method -> {
            Variable thisVariable = method.getScope().getThis();
            method.getBody().append((BytecodeNode)thisVariable.setField(selectedPositions, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(boolean[].class), (int)0)));
        });
        return classDefinition;
    }

    private static MethodDefinition generatePageFilterMethod(ClassDefinition classDefinition, FieldDefinition selectedPositionsField) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(SelectedPositions.class), (Iterable)ImmutableList.builder().add((Object)session).add((Object)page).build());
        Scope scope = method.getScope();
        Variable thisVariable = method.getThis();
        BytecodeBlock body = method.getBody();
        Variable positionCount = scope.declareVariable("positionCount", body, page.invoke("getPositionCount", Integer.TYPE, new BytecodeExpression[0]));
        body.append((BytecodeNode)new IfStatement("grow selectedPositions if necessary", new Object[0]).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)thisVariable.getField(selectedPositionsField).length(), (BytecodeExpression)positionCount)).ifTrue((BytecodeNode)thisVariable.setField(selectedPositionsField, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(boolean[].class), (BytecodeExpression)positionCount))));
        Variable selectedPositions = scope.declareVariable("selectedPositions", body, thisVariable.getField(selectedPositionsField));
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        body.append((BytecodeNode)new ForLoop().initialize((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0))).condition((BytecodeNode)BytecodeExpressions.lessThan((BytecodeExpression)position, (BytecodeExpression)positionCount)).update((BytecodeNode)position.increment()).body((BytecodeNode)selectedPositions.setElement((BytecodeExpression)position, thisVariable.invoke("filter", Boolean.TYPE, new BytecodeExpression[]{session, page, position}))));
        body.append((BytecodeNode)BytecodeExpressions.invokeStatic(PageFilter.class, (String)"positionsArrayToSelectedPositions", SelectedPositions.class, (BytecodeExpression[])new BytecodeExpression[]{selectedPositions, positionCount}).ret());
        return method;
    }

    private MethodDefinition generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap, RowExpression filter) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter page = Parameter.arg((String)"page", Page.class);
        Parameter position = Parameter.arg((String)"position", Integer.TYPE);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(Boolean.TYPE), (Iterable)ImmutableList.builder().add((Object)session).add((Object)page).add((Object)position).build());
        method.comment("Filter: %s", new Object[]{filter.toString()});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        PageFunctionCompiler.declareBlockVariables(filter, page, scope, body);
        Variable wasNullVariable = scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        RowExpressionCompiler compiler = new RowExpressionCompiler(callSiteBinder, cachedInstanceBinder, PageFunctionCompiler.fieldReferenceCompiler(callSiteBinder), this.metadata.getFunctionManager(), compiledLambdaMap);
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        body.append(compiler.compile(filter, scope, Optional.empty())).putVariable(result).append((BytecodeNode)BytecodeExpressions.and((BytecodeExpression)BytecodeExpressions.not((BytecodeExpression)wasNullVariable), (BytecodeExpression)result).ret());
        return method;
    }

    private Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> generateMethodsForLambda(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression expression) {
        ImmutableSet lambdaExpressions = ImmutableSet.copyOf(LambdaExpressionExtractor.extractLambdaExpressions(expression));
        ImmutableMap.Builder compiledLambdaMap = ImmutableMap.builder();
        int counter = 0;
        for (LambdaDefinitionExpression lambdaExpression : lambdaExpressions) {
            LambdaBytecodeGenerator.CompiledLambda compiledLambda = LambdaBytecodeGenerator.preGenerateLambdaExpression(lambdaExpression, "lambda_" + counter, containerClassDefinition, (Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda>)compiledLambdaMap.build(), callSiteBinder, cachedInstanceBinder, this.metadata.getFunctionManager());
            compiledLambdaMap.put((Object)lambdaExpression, (Object)compiledLambda);
            ++counter;
        }
        return compiledLambdaMap.build();
    }

    private static void generateConstructor(ClassDefinition classDefinition, CachedInstanceBinder cachedInstanceBinder, Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap, Consumer<MethodDefinition> additionalStatements) {
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock body = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        additionalStatements.accept(constructorDefinition);
        cachedInstanceBinder.generateInitializations(thisVariable, body);
        body.ret();
    }

    private static void declareBlockVariables(RowExpression expression, Parameter page, Scope scope, BytecodeBlock body) {
        for (int channel : PageFunctionCompiler.getInputChannels(expression)) {
            scope.declareVariable("block_" + channel, body, page.invoke("getBlock", Block.class, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)channel)}));
        }
    }

    private static List<Integer> getInputChannels(Iterable<RowExpression> expressions) {
        TreeSet<Integer> channels = new TreeSet<Integer>();
        for (RowExpression expression : Expressions.subExpressions(expressions)) {
            if (!(expression instanceof InputReferenceExpression)) continue;
            channels.add(((InputReferenceExpression)expression).getField());
        }
        return ImmutableList.copyOf(channels);
    }

    private static List<Integer> getInputChannels(RowExpression expression) {
        return PageFunctionCompiler.getInputChannels((Iterable<RowExpression>)ImmutableList.of((Object)expression));
    }

    private static List<Parameter> toBlockParameters(List<Integer> inputChannels) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int channel : inputChannels) {
            parameters.add((Object)Parameter.arg((String)("block_" + channel), Block.class));
        }
        return parameters.build();
    }

    private static RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler(CallSiteBinder callSiteBinder) {
        return new InputReferenceCompiler((scope, field) -> scope.getVariable("block_" + field), (scope, field) -> scope.getVariable("position"), callSiteBinder);
    }
}

