/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.Constant;
import java.util.List;
import java.util.Optional;

public class IsNullCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0);
        RowExpression argument = arguments.get(0);
        if (argument.getType().equals((Object)UnknownType.UNKNOWN)) {
            return Constant.loadBoolean((boolean)true);
        }
        BytecodeNode value = generatorContext.generate(argument, Optional.empty());
        Variable wasNull = generatorContext.wasNull();
        BytecodeBlock block = new BytecodeBlock().comment("is null").append(value).pop(argument.getType().getJavaType()).append((BytecodeNode)wasNull);
        block.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        outputBlockVariable.ifPresent(output -> block.append(BytecodeGenerator.generateWrite(generatorContext, returnType, output)));
        return block;
    }
}

