/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.RowExpressionCompiler;
import com.facebook.presto.sql.relational.RowExpression;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BytecodeGeneratorContext {
    private final RowExpressionCompiler rowExpressionCompiler;
    private final Scope scope;
    private final CallSiteBinder callSiteBinder;
    private final CachedInstanceBinder cachedInstanceBinder;
    private final FunctionManager manager;
    private final Variable wasNull;

    public BytecodeGeneratorContext(RowExpressionCompiler rowExpressionCompiler, Scope scope, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, FunctionManager manager) {
        Objects.requireNonNull(rowExpressionCompiler, "bytecodeGenerator is null");
        Objects.requireNonNull(cachedInstanceBinder, "cachedInstanceBinder is null");
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
        Objects.requireNonNull(manager, "manager is null");
        this.rowExpressionCompiler = rowExpressionCompiler;
        this.scope = scope;
        this.callSiteBinder = callSiteBinder;
        this.cachedInstanceBinder = cachedInstanceBinder;
        this.manager = manager;
        this.wasNull = scope.getVariable("wasNull");
    }

    public Scope getScope() {
        return this.scope;
    }

    public CallSiteBinder getCallSiteBinder() {
        return this.callSiteBinder;
    }

    public BytecodeNode generate(RowExpression expression, Optional<Variable> outputBlockVariable) {
        return this.generate(expression, outputBlockVariable, Optional.empty());
    }

    public BytecodeNode generate(RowExpression expression, Optional<Variable> outputBlockVariable, Optional<Class> lambdaInterface) {
        return this.rowExpressionCompiler.compile(expression, this.scope, outputBlockVariable, lambdaInterface);
    }

    public FunctionManager getFunctionManager() {
        return this.manager;
    }

    public BytecodeNode generateCall(String name, ScalarFunctionImplementation function, List<BytecodeNode> arguments) {
        return this.generateCall(name, function, arguments, Optional.empty());
    }

    public BytecodeNode generateCall(String name, ScalarFunctionImplementation function, List<BytecodeNode> arguments, Optional<BytecodeUtils.OutputBlockVariableAndType> outputBlockVariableAndType) {
        Optional<BytecodeNode> instance = Optional.empty();
        if (function.getInstanceFactory().isPresent()) {
            FieldDefinition field = this.cachedInstanceBinder.getCachedInstance(function.getInstanceFactory().get());
            instance = Optional.of(this.scope.getThis().getField(field));
        }
        return BytecodeUtils.generateInvocation(this.scope, name, function, instance, arguments, this.callSiteBinder, outputBlockVariableAndType);
    }

    public Variable wasNull() {
        return this.wasNull;
    }
}

