/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class TypeSignatureProvider {
    private final boolean hasDependency;
    private final Function<List<Type>, TypeSignature> typeSignatureResolver;

    public TypeSignatureProvider(TypeSignature typeSignature) {
        this.hasDependency = false;
        this.typeSignatureResolver = ignored -> typeSignature;
    }

    public TypeSignatureProvider(Function<List<Type>, TypeSignature> typeSignatureResolver) {
        this.hasDependency = true;
        this.typeSignatureResolver = Objects.requireNonNull(typeSignatureResolver, "typeSignatureResolver is null");
    }

    public boolean hasDependency() {
        return this.hasDependency;
    }

    public TypeSignature getTypeSignature() {
        Preconditions.checkState((!this.hasDependency ? 1 : 0) != 0);
        return this.typeSignatureResolver.apply((List<Type>)ImmutableList.of());
    }

    public TypeSignature getTypeSignature(List<Type> boundTypeParameters) {
        Preconditions.checkState((boolean)this.hasDependency);
        return this.typeSignatureResolver.apply(boundTypeParameters);
    }

    public static List<TypeSignatureProvider> fromTypes(Type ... types) {
        return TypeSignatureProvider.fromTypes((List<? extends Type>)ImmutableList.copyOf((Object[])types));
    }

    public static List<TypeSignatureProvider> fromTypes(List<? extends Type> types) {
        return (List)types.stream().map(Type::getTypeSignature).map(TypeSignatureProvider::new).collect(ImmutableList.toImmutableList());
    }

    public static List<TypeSignatureProvider> fromTypeSignatures(List<? extends TypeSignature> typeSignatures) {
        return (List)typeSignatures.stream().map(TypeSignatureProvider::new).collect(ImmutableList.toImmutableList());
    }

    public String toString() {
        if (this.hasDependency) {
            return super.toString();
        }
        return this.getTypeSignature().toString();
    }
}

