/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.QuantifiedComparisonExpression;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Table;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public class Analysis {
    @Nullable
    private final Statement root;
    private final List<Expression> parameters;
    private String updateType;
    private final Map<NodeRef<Table>, Query> namedQueries = new LinkedHashMap<NodeRef<Table>, Query>();
    private final Map<NodeRef<Node>, Scope> scopes = new LinkedHashMap<NodeRef<Node>, Scope>();
    private final Map<NodeRef<Expression>, FieldId> columnReferences = new LinkedHashMap<NodeRef<Expression>, FieldId>();
    private final Map<AccessControlInfo, Map<QualifiedObjectName, Set<String>>> tableColumnReferences = new LinkedHashMap<AccessControlInfo, Map<QualifiedObjectName, Set<String>>>();
    private final Map<NodeRef<QuerySpecification>, List<FunctionCall>> aggregates = new LinkedHashMap<NodeRef<QuerySpecification>, List<FunctionCall>>();
    private final Map<NodeRef<OrderBy>, List<Expression>> orderByAggregates = new LinkedHashMap<NodeRef<OrderBy>, List<Expression>>();
    private final Map<NodeRef<QuerySpecification>, List<Expression>> groupByExpressions = new LinkedHashMap<NodeRef<QuerySpecification>, List<Expression>>();
    private final Map<NodeRef<QuerySpecification>, GroupingSetAnalysis> groupingSets = new LinkedHashMap<NodeRef<QuerySpecification>, GroupingSetAnalysis>();
    private final Map<NodeRef<Node>, Expression> where = new LinkedHashMap<NodeRef<Node>, Expression>();
    private final Map<NodeRef<QuerySpecification>, Expression> having = new LinkedHashMap<NodeRef<QuerySpecification>, Expression>();
    private final Map<NodeRef<Node>, List<Expression>> orderByExpressions = new LinkedHashMap<NodeRef<Node>, List<Expression>>();
    private final Map<NodeRef<Node>, List<Expression>> outputExpressions = new LinkedHashMap<NodeRef<Node>, List<Expression>>();
    private final Map<NodeRef<QuerySpecification>, List<FunctionCall>> windowFunctions = new LinkedHashMap<NodeRef<QuerySpecification>, List<FunctionCall>>();
    private final Map<NodeRef<OrderBy>, List<FunctionCall>> orderByWindowFunctions = new LinkedHashMap<NodeRef<OrderBy>, List<FunctionCall>>();
    private final Map<NodeRef<Join>, Expression> joins = new LinkedHashMap<NodeRef<Join>, Expression>();
    private final Map<NodeRef<Join>, JoinUsingAnalysis> joinUsing = new LinkedHashMap<NodeRef<Join>, JoinUsingAnalysis>();
    private final ListMultimap<NodeRef<Node>, InPredicate> inPredicatesSubqueries = ArrayListMultimap.create();
    private final ListMultimap<NodeRef<Node>, SubqueryExpression> scalarSubqueries = ArrayListMultimap.create();
    private final ListMultimap<NodeRef<Node>, ExistsPredicate> existsSubqueries = ArrayListMultimap.create();
    private final ListMultimap<NodeRef<Node>, QuantifiedComparisonExpression> quantifiedComparisonSubqueries = ArrayListMultimap.create();
    private final Map<NodeRef<Table>, TableHandle> tables = new LinkedHashMap<NodeRef<Table>, TableHandle>();
    private final Map<NodeRef<Expression>, Type> types = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Map<NodeRef<Expression>, Type> coercions = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Set<NodeRef<Expression>> typeOnlyCoercions = new LinkedHashSet<NodeRef<Expression>>();
    private final Map<NodeRef<Relation>, List<Type>> relationCoercions = new LinkedHashMap<NodeRef<Relation>, List<Type>>();
    private final Map<NodeRef<FunctionCall>, FunctionHandle> functionHandles = new LinkedHashMap<NodeRef<FunctionCall>, FunctionHandle>();
    private final Map<NodeRef<Identifier>, LambdaArgumentDeclaration> lambdaArgumentReferences = new LinkedHashMap<NodeRef<Identifier>, LambdaArgumentDeclaration>();
    private final Map<Field, ColumnHandle> columns = new LinkedHashMap<Field, ColumnHandle>();
    private final Map<NodeRef<SampledRelation>, Double> sampleRatios = new LinkedHashMap<NodeRef<SampledRelation>, Double>();
    private final Map<NodeRef<QuerySpecification>, List<GroupingOperation>> groupingOperations = new LinkedHashMap<NodeRef<QuerySpecification>, List<GroupingOperation>>();
    private Optional<QualifiedObjectName> createTableDestination = Optional.empty();
    private Map<String, Expression> createTableProperties = ImmutableMap.of();
    private boolean createTableAsSelectWithData = true;
    private boolean createTableAsSelectNoOp;
    private Optional<List<Identifier>> createTableColumnAliases = Optional.empty();
    private Optional<String> createTableComment = Optional.empty();
    private Optional<Insert> insert = Optional.empty();
    private Optional<TableHandle> analyzeTarget = Optional.empty();
    private final boolean isDescribe;
    private final Deque<Table> tablesForView = new ArrayDeque<Table>();

    public Analysis(@Nullable Statement root, List<Expression> parameters, boolean isDescribe) {
        Objects.requireNonNull(parameters);
        this.root = root;
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
        this.isDescribe = isDescribe;
    }

    public Statement getStatement() {
        return this.root;
    }

    public String getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public boolean isCreateTableAsSelectWithData() {
        return this.createTableAsSelectWithData;
    }

    public void setCreateTableAsSelectWithData(boolean createTableAsSelectWithData) {
        this.createTableAsSelectWithData = createTableAsSelectWithData;
    }

    public boolean isCreateTableAsSelectNoOp() {
        return this.createTableAsSelectNoOp;
    }

    public void setCreateTableAsSelectNoOp(boolean createTableAsSelectNoOp) {
        this.createTableAsSelectNoOp = createTableAsSelectNoOp;
    }

    public void setAggregates(QuerySpecification node, List<FunctionCall> aggregates) {
        this.aggregates.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), (List<FunctionCall>)ImmutableList.copyOf(aggregates));
    }

    public List<FunctionCall> getAggregates(QuerySpecification query) {
        return this.aggregates.get(NodeRef.of((Node)query));
    }

    public void setOrderByAggregates(OrderBy node, List<Expression> aggregates) {
        this.orderByAggregates.put((NodeRef<OrderBy>)NodeRef.of((Node)node), (List<Expression>)ImmutableList.copyOf(aggregates));
    }

    public List<Expression> getOrderByAggregates(OrderBy node) {
        return this.orderByAggregates.get(NodeRef.of((Node)node));
    }

    public Map<NodeRef<Expression>, Type> getTypes() {
        return Collections.unmodifiableMap(this.types);
    }

    public Type getType(Expression expression) {
        Type type = this.types.get(NodeRef.of((Node)expression));
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Expression not analyzed: %s", (Object)expression);
        return type;
    }

    public Type getTypeWithCoercions(Expression expression) {
        NodeRef key = NodeRef.of((Node)expression);
        Preconditions.checkArgument((boolean)this.types.containsKey(key), (String)"Expression not analyzed: %s", (Object)expression);
        if (this.coercions.containsKey(key)) {
            return this.coercions.get(key);
        }
        return this.types.get(key);
    }

    public Type[] getRelationCoercion(Relation relation) {
        return Optional.ofNullable(this.relationCoercions.get(NodeRef.of((Node)relation))).map(types -> (Type[])types.stream().toArray(Type[]::new)).orElse(null);
    }

    public void addRelationCoercion(Relation relation, Type[] types) {
        this.relationCoercions.put((NodeRef<Relation>)NodeRef.of((Node)relation), (List<Type>)ImmutableList.copyOf((Object[])types));
    }

    public Map<NodeRef<Expression>, Type> getCoercions() {
        return Collections.unmodifiableMap(this.coercions);
    }

    public Set<NodeRef<Expression>> getTypeOnlyCoercions() {
        return Collections.unmodifiableSet(this.typeOnlyCoercions);
    }

    public Type getCoercion(Expression expression) {
        return this.coercions.get(NodeRef.of((Node)expression));
    }

    public void addLambdaArgumentReferences(Map<NodeRef<Identifier>, LambdaArgumentDeclaration> lambdaArgumentReferences) {
        this.lambdaArgumentReferences.putAll(lambdaArgumentReferences);
    }

    public LambdaArgumentDeclaration getLambdaArgumentReference(Identifier identifier) {
        return this.lambdaArgumentReferences.get(NodeRef.of((Node)identifier));
    }

    public Map<NodeRef<Identifier>, LambdaArgumentDeclaration> getLambdaArgumentReferences() {
        return Collections.unmodifiableMap(this.lambdaArgumentReferences);
    }

    public void setGroupingSets(QuerySpecification node, GroupingSetAnalysis groupingSets) {
        this.groupingSets.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), groupingSets);
    }

    public void setGroupByExpressions(QuerySpecification node, List<Expression> expressions) {
        this.groupByExpressions.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), expressions);
    }

    public boolean isAggregation(QuerySpecification node) {
        return this.groupByExpressions.containsKey(NodeRef.of((Node)node));
    }

    public boolean isTypeOnlyCoercion(Expression expression) {
        return this.typeOnlyCoercions.contains(NodeRef.of((Node)expression));
    }

    public GroupingSetAnalysis getGroupingSets(QuerySpecification node) {
        return this.groupingSets.get(NodeRef.of((Node)node));
    }

    public List<Expression> getGroupByExpressions(QuerySpecification node) {
        return this.groupByExpressions.get(NodeRef.of((Node)node));
    }

    public void setWhere(Node node, Expression expression) {
        this.where.put((NodeRef<Node>)NodeRef.of((Node)node), expression);
    }

    public Expression getWhere(QuerySpecification node) {
        return this.where.get(NodeRef.of((Node)node));
    }

    public void setOrderByExpressions(Node node, List<Expression> items) {
        this.orderByExpressions.put((NodeRef<Node>)NodeRef.of((Node)node), (List<Expression>)ImmutableList.copyOf(items));
    }

    public List<Expression> getOrderByExpressions(Node node) {
        return this.orderByExpressions.get(NodeRef.of((Node)node));
    }

    public void setOutputExpressions(Node node, List<Expression> expressions) {
        this.outputExpressions.put((NodeRef<Node>)NodeRef.of((Node)node), (List<Expression>)ImmutableList.copyOf(expressions));
    }

    public List<Expression> getOutputExpressions(Node node) {
        return this.outputExpressions.get(NodeRef.of((Node)node));
    }

    public void setHaving(QuerySpecification node, Expression expression) {
        this.having.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), expression);
    }

    public void setJoinCriteria(Join node, Expression criteria) {
        this.joins.put((NodeRef<Join>)NodeRef.of((Node)node), criteria);
    }

    public Expression getJoinCriteria(Join join) {
        return this.joins.get(NodeRef.of((Node)join));
    }

    public void recordSubqueries(Node node, ExpressionAnalysis expressionAnalysis) {
        NodeRef key = NodeRef.of((Node)node);
        this.inPredicatesSubqueries.putAll((Object)key, this.dereference(expressionAnalysis.getSubqueryInPredicates()));
        this.scalarSubqueries.putAll((Object)key, this.dereference(expressionAnalysis.getScalarSubqueries()));
        this.existsSubqueries.putAll((Object)key, this.dereference(expressionAnalysis.getExistsSubqueries()));
        this.quantifiedComparisonSubqueries.putAll((Object)key, this.dereference(expressionAnalysis.getQuantifiedComparisons()));
    }

    private <T extends Node> List<T> dereference(Collection<NodeRef<T>> nodeRefs) {
        return (List)nodeRefs.stream().map(NodeRef::getNode).collect(ImmutableList.toImmutableList());
    }

    public List<InPredicate> getInPredicateSubqueries(Node node) {
        return ImmutableList.copyOf((Collection)this.inPredicatesSubqueries.get((Object)NodeRef.of((Node)node)));
    }

    public List<SubqueryExpression> getScalarSubqueries(Node node) {
        return ImmutableList.copyOf((Collection)this.scalarSubqueries.get((Object)NodeRef.of((Node)node)));
    }

    public List<ExistsPredicate> getExistsSubqueries(Node node) {
        return ImmutableList.copyOf((Collection)this.existsSubqueries.get((Object)NodeRef.of((Node)node)));
    }

    public List<QuantifiedComparisonExpression> getQuantifiedComparisonSubqueries(Node node) {
        return Collections.unmodifiableList(this.quantifiedComparisonSubqueries.get((Object)NodeRef.of((Node)node)));
    }

    public void setWindowFunctions(QuerySpecification node, List<FunctionCall> functions) {
        this.windowFunctions.put((NodeRef<QuerySpecification>)NodeRef.of((Node)node), (List<FunctionCall>)ImmutableList.copyOf(functions));
    }

    public List<FunctionCall> getWindowFunctions(QuerySpecification query) {
        return this.windowFunctions.get(NodeRef.of((Node)query));
    }

    public void setOrderByWindowFunctions(OrderBy node, List<FunctionCall> functions) {
        this.orderByWindowFunctions.put((NodeRef<OrderBy>)NodeRef.of((Node)node), (List<FunctionCall>)ImmutableList.copyOf(functions));
    }

    public List<FunctionCall> getOrderByWindowFunctions(OrderBy query) {
        return this.orderByWindowFunctions.get(NodeRef.of((Node)query));
    }

    public void addColumnReferences(Map<NodeRef<Expression>, FieldId> columnReferences) {
        this.columnReferences.putAll(columnReferences);
    }

    public Scope getScope(Node node) {
        return this.tryGetScope(node).orElseThrow(() -> new IllegalArgumentException(String.format("Analysis does not contain information for node: %s", node)));
    }

    public Optional<Scope> tryGetScope(Node node) {
        NodeRef key = NodeRef.of((Node)node);
        if (this.scopes.containsKey(key)) {
            return Optional.of(this.scopes.get(key));
        }
        return Optional.empty();
    }

    public Scope getRootScope() {
        return this.getScope((Node)this.root);
    }

    public void setScope(Node node, Scope scope) {
        this.scopes.put((NodeRef<Node>)NodeRef.of((Node)node), scope);
    }

    public RelationType getOutputDescriptor() {
        return this.getOutputDescriptor((Node)this.root);
    }

    public RelationType getOutputDescriptor(Node node) {
        return this.getScope(node).getRelationType();
    }

    public TableHandle getTableHandle(Table table) {
        return this.tables.get(NodeRef.of((Node)table));
    }

    public Collection<TableHandle> getTables() {
        return Collections.unmodifiableCollection(this.tables.values());
    }

    public void registerTable(Table table, TableHandle handle) {
        this.tables.put((NodeRef<Table>)NodeRef.of((Node)table), handle);
    }

    public FunctionHandle getFunctionHandle(FunctionCall function) {
        return this.functionHandles.get(NodeRef.of((Node)function));
    }

    public void addFunctionHandles(Map<NodeRef<FunctionCall>, FunctionHandle> infos) {
        this.functionHandles.putAll(infos);
    }

    public Set<NodeRef<Expression>> getColumnReferences() {
        return Collections.unmodifiableSet(this.columnReferences.keySet());
    }

    public Map<NodeRef<Expression>, FieldId> getColumnReferenceFields() {
        return Collections.unmodifiableMap(this.columnReferences);
    }

    public boolean isColumnReference(Expression expression) {
        Objects.requireNonNull(expression, "expression is null");
        Preconditions.checkArgument((this.getType(expression) != null ? 1 : 0) != 0, (String)"expression %s has not been analyzed", (Object)expression);
        return this.columnReferences.containsKey(NodeRef.of((Node)expression));
    }

    public void addTypes(Map<NodeRef<Expression>, Type> types) {
        this.types.putAll(types);
    }

    public void addCoercion(Expression expression, Type type, boolean isTypeOnlyCoercion) {
        this.coercions.put((NodeRef<Expression>)NodeRef.of((Node)expression), type);
        if (isTypeOnlyCoercion) {
            this.typeOnlyCoercions.add((NodeRef<Expression>)NodeRef.of((Node)expression));
        }
    }

    public void addCoercions(Map<NodeRef<Expression>, Type> coercions, Set<NodeRef<Expression>> typeOnlyCoercions) {
        this.coercions.putAll(coercions);
        this.typeOnlyCoercions.addAll(typeOnlyCoercions);
    }

    public Expression getHaving(QuerySpecification query) {
        return this.having.get(NodeRef.of((Node)query));
    }

    public void setColumn(Field field, ColumnHandle handle) {
        this.columns.put(field, handle);
    }

    public ColumnHandle getColumn(Field field) {
        return this.columns.get(field);
    }

    public void setCreateTableDestination(QualifiedObjectName destination) {
        this.createTableDestination = Optional.of(destination);
    }

    public Optional<QualifiedObjectName> getCreateTableDestination() {
        return this.createTableDestination;
    }

    public Optional<TableHandle> getAnalyzeTarget() {
        return this.analyzeTarget;
    }

    public void setAnalyzeTarget(TableHandle analyzeTarget) {
        this.analyzeTarget = Optional.of(analyzeTarget);
    }

    public void setCreateTableProperties(Map<String, Expression> createTableProperties) {
        this.createTableProperties = ImmutableMap.copyOf(createTableProperties);
    }

    public Map<String, Expression> getCreateTableProperties() {
        return this.createTableProperties;
    }

    public Optional<List<Identifier>> getColumnAliases() {
        return this.createTableColumnAliases;
    }

    public void setCreateTableColumnAliases(List<Identifier> createTableColumnAliases) {
        this.createTableColumnAliases = Optional.of(createTableColumnAliases);
    }

    public void setCreateTableComment(Optional<String> createTableComment) {
        this.createTableComment = Objects.requireNonNull(createTableComment);
    }

    public Optional<String> getCreateTableComment() {
        return this.createTableComment;
    }

    public void setInsert(Insert insert) {
        this.insert = Optional.of(insert);
    }

    public Optional<Insert> getInsert() {
        return this.insert;
    }

    public Query getNamedQuery(Table table) {
        return this.namedQueries.get(NodeRef.of((Node)table));
    }

    public void registerNamedQuery(Table tableReference, Query query) {
        Objects.requireNonNull(tableReference, "tableReference is null");
        Objects.requireNonNull(query, "query is null");
        this.namedQueries.put((NodeRef<Table>)NodeRef.of((Node)tableReference), query);
    }

    public void registerTableForView(Table tableReference) {
        this.tablesForView.push(Objects.requireNonNull(tableReference, "table is null"));
    }

    public void unregisterTableForView() {
        this.tablesForView.pop();
    }

    public boolean hasTableInView(Table tableReference) {
        return this.tablesForView.contains(tableReference);
    }

    public void setSampleRatio(SampledRelation relation, double ratio) {
        this.sampleRatios.put((NodeRef<SampledRelation>)NodeRef.of((Node)relation), ratio);
    }

    public double getSampleRatio(SampledRelation relation) {
        NodeRef key = NodeRef.of((Node)relation);
        Preconditions.checkState((boolean)this.sampleRatios.containsKey(key), (String)"Sample ratio missing for %s. Broken analysis?", (Object)relation);
        return this.sampleRatios.get(key);
    }

    public void setGroupingOperations(QuerySpecification querySpecification, List<GroupingOperation> groupingOperations) {
        this.groupingOperations.put((NodeRef<QuerySpecification>)NodeRef.of((Node)querySpecification), (List<GroupingOperation>)ImmutableList.copyOf(groupingOperations));
    }

    public List<GroupingOperation> getGroupingOperations(QuerySpecification querySpecification) {
        return Optional.ofNullable(this.groupingOperations.get(NodeRef.of((Node)querySpecification))).orElse(Collections.emptyList());
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public boolean isDescribe() {
        return this.isDescribe;
    }

    public void setJoinUsing(Join node, JoinUsingAnalysis analysis) {
        this.joinUsing.put((NodeRef<Join>)NodeRef.of((Node)node), analysis);
    }

    public JoinUsingAnalysis getJoinUsing(Join node) {
        return this.joinUsing.get(NodeRef.of((Node)node));
    }

    public void addTableColumnReferences(AccessControl accessControl, Identity identity, Multimap<QualifiedObjectName, String> tableColumnMap) {
        AccessControlInfo accessControlInfo = new AccessControlInfo(accessControl, identity);
        Map references = this.tableColumnReferences.computeIfAbsent(accessControlInfo, k -> new LinkedHashMap());
        tableColumnMap.asMap().forEach((key, value) -> references.computeIfAbsent(key, k -> new HashSet()).addAll(value));
    }

    public void addEmptyColumnReferencesForTable(AccessControl accessControl, Identity identity, QualifiedObjectName table) {
        AccessControlInfo accessControlInfo = new AccessControlInfo(accessControl, identity);
        this.tableColumnReferences.computeIfAbsent(accessControlInfo, k -> new LinkedHashMap()).computeIfAbsent(table, k -> new HashSet());
    }

    public Map<AccessControlInfo, Map<QualifiedObjectName, Set<String>>> getTableColumnReferences() {
        return this.tableColumnReferences;
    }

    public static final class AccessControlInfo {
        private final AccessControl accessControl;
        private final Identity identity;

        public AccessControlInfo(AccessControl accessControl, Identity identity) {
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.identity = Objects.requireNonNull(identity, "identity is null");
        }

        public AccessControl getAccessControl() {
            return this.accessControl;
        }

        public Identity getIdentity() {
            return this.identity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AccessControlInfo that = (AccessControlInfo)o;
            return Objects.equals(this.accessControl, that.accessControl) && Objects.equals(this.identity, that.identity);
        }

        public int hashCode() {
            return Objects.hash(this.accessControl, this.identity);
        }

        public String toString() {
            return String.format("AccessControl: %s, Identity: %s", this.accessControl.getClass(), this.identity);
        }
    }

    public static class GroupingSetAnalysis {
        private final List<Set<FieldId>> cubes;
        private final List<List<FieldId>> rollups;
        private final List<List<Set<FieldId>>> ordinarySets;
        private final List<Expression> complexExpressions;

        public GroupingSetAnalysis(List<Set<FieldId>> cubes, List<List<FieldId>> rollups, List<List<Set<FieldId>>> ordinarySets, List<Expression> complexExpressions) {
            this.cubes = ImmutableList.copyOf(cubes);
            this.rollups = ImmutableList.copyOf(rollups);
            this.ordinarySets = ImmutableList.copyOf(ordinarySets);
            this.complexExpressions = ImmutableList.copyOf(complexExpressions);
        }

        public List<Set<FieldId>> getCubes() {
            return this.cubes;
        }

        public List<List<FieldId>> getRollups() {
            return this.rollups;
        }

        public List<List<Set<FieldId>>> getOrdinarySets() {
            return this.ordinarySets;
        }

        public List<Expression> getComplexExpressions() {
            return this.complexExpressions;
        }
    }

    public static final class JoinUsingAnalysis {
        private final List<Integer> leftJoinFields;
        private final List<Integer> rightJoinFields;
        private final List<Integer> otherLeftFields;
        private final List<Integer> otherRightFields;

        JoinUsingAnalysis(List<Integer> leftJoinFields, List<Integer> rightJoinFields, List<Integer> otherLeftFields, List<Integer> otherRightFields) {
            this.leftJoinFields = ImmutableList.copyOf(leftJoinFields);
            this.rightJoinFields = ImmutableList.copyOf(rightJoinFields);
            this.otherLeftFields = ImmutableList.copyOf(otherLeftFields);
            this.otherRightFields = ImmutableList.copyOf(otherRightFields);
            Preconditions.checkArgument((leftJoinFields.size() == rightJoinFields.size() ? 1 : 0) != 0, (Object)"Expected join fields for left and right to have the same size");
        }

        public List<Integer> getLeftJoinFields() {
            return this.leftJoinFields;
        }

        public List<Integer> getRightJoinFields() {
            return this.rightJoinFields;
        }

        public List<Integer> getOtherLeftFields() {
            return this.otherLeftFields;
        }

        public List<Integer> getOtherRightFields() {
            return this.otherRightFields;
        }
    }

    @Immutable
    public static final class Insert {
        private final TableHandle target;
        private final List<ColumnHandle> columns;

        public Insert(TableHandle target, List<ColumnHandle> columns) {
            this.target = Objects.requireNonNull(target, "target is null");
            this.columns = Objects.requireNonNull(columns, "columns is null");
            Preconditions.checkArgument((columns.size() > 0 ? 1 : 0) != 0, (Object)"No columns given to insert");
        }

        public List<ColumnHandle> getColumns() {
            return this.columns;
        }

        public TableHandle getTarget() {
            return this.target;
        }
    }
}

