/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class MappedPageSource
implements ConnectorPageSource {
    private final ConnectorPageSource delegate;
    private final int[] delegateFieldIndex;

    public MappedPageSource(ConnectorPageSource delegate, List<Integer> delegateFieldIndex) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.delegateFieldIndex = Ints.toArray((Collection)Objects.requireNonNull(delegateFieldIndex, "delegateFieldIndex is null"));
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        Page nextPage = this.delegate.getNextPage();
        if (nextPage == null) {
            return null;
        }
        Block[] blocks = (Block[])Arrays.stream(this.delegateFieldIndex).mapToObj(arg_0 -> ((Page)nextPage).getBlock(arg_0)).toArray(Block[]::new);
        return new Page(nextPage.getPositionCount(), blocks);
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

