/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.Session;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.ForScheduler;
import com.facebook.presto.server.InternalCommunicationConfig;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.server.remotetask.HttpRemoteTask;
import com.facebook.presto.server.remotetask.RemoteTaskStats;
import com.facebook.presto.server.smile.Codec;
import com.facebook.presto.server.smile.JsonCodecWrapper;
import com.facebook.presto.server.smile.SmileCodec;
import com.facebook.presto.spi.Node;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.collect.Multimap;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.http.client.HttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HttpRemoteTaskFactory
implements RemoteTaskFactory {
    private final HttpClient httpClient;
    private final LocationFactory locationFactory;
    private final Codec<TaskStatus> taskStatusCodec;
    private final Codec<TaskInfo> taskInfoCodec;
    private final Codec<TaskUpdateRequest> taskUpdateRequestCodec;
    private final Duration maxErrorDuration;
    private final Duration taskStatusRefreshMaxWait;
    private final Duration taskInfoUpdateInterval;
    private final ExecutorService coreExecutor;
    private final Executor executor;
    private final ThreadPoolExecutorMBean executorMBean;
    private final ScheduledExecutorService updateScheduledExecutor;
    private final ScheduledExecutorService errorScheduledExecutor;
    private final RemoteTaskStats stats;
    private final boolean isBinaryTransportEnabled;

    @Inject
    public HttpRemoteTaskFactory(QueryManagerConfig config, TaskManagerConfig taskConfig, @ForScheduler HttpClient httpClient, LocationFactory locationFactory, JsonCodec<TaskStatus> taskStatusJsonCodec, SmileCodec<TaskStatus> taskStatusSmileCodec, JsonCodec<TaskInfo> taskInfoJsonCodec, SmileCodec<TaskInfo> taskInfoSmileCodec, JsonCodec<TaskUpdateRequest> taskUpdateRequestJsonCodec, SmileCodec<TaskUpdateRequest> taskUpdateRequestSmileCodec, RemoteTaskStats stats, InternalCommunicationConfig communicationConfig) {
        this.httpClient = httpClient;
        this.locationFactory = locationFactory;
        this.maxErrorDuration = config.getRemoteTaskMaxErrorDuration();
        this.taskStatusRefreshMaxWait = taskConfig.getStatusRefreshMaxWait();
        this.taskInfoUpdateInterval = taskConfig.getInfoUpdateInterval();
        this.coreExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"remote-task-callback-%s"));
        this.executor = new BoundedExecutor((Executor)this.coreExecutor, config.getRemoteTaskMaxCallbackThreads());
        this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.coreExecutor);
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.isBinaryTransportEnabled = Objects.requireNonNull(communicationConfig, "communicationConfig is null").isBinaryTransportEnabled();
        if (this.isBinaryTransportEnabled) {
            this.taskStatusCodec = taskStatusSmileCodec;
            this.taskInfoCodec = taskInfoSmileCodec;
            this.taskUpdateRequestCodec = taskUpdateRequestSmileCodec;
        } else {
            this.taskStatusCodec = JsonCodecWrapper.wrapJsonCodec(taskStatusJsonCodec);
            this.taskInfoCodec = JsonCodecWrapper.wrapJsonCodec(taskInfoJsonCodec);
            this.taskUpdateRequestCodec = JsonCodecWrapper.wrapJsonCodec(taskUpdateRequestJsonCodec);
        }
        this.updateScheduledExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"task-info-update-scheduler-%s"));
        this.errorScheduledExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"remote-task-error-delay-%s"));
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }

    @PreDestroy
    public void stop() {
        this.coreExecutor.shutdownNow();
        this.updateScheduledExecutor.shutdownNow();
        this.errorScheduledExecutor.shutdownNow();
    }

    @Override
    public RemoteTask createRemoteTask(Session session, TaskId taskId, Node node, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OptionalInt totalPartitions, OutputBuffers outputBuffers, NodeTaskMap.PartitionedSplitCountTracker partitionedSplitCountTracker, boolean summarizeTaskInfo) {
        return new HttpRemoteTask(session, taskId, node.getNodeIdentifier(), this.locationFactory.createTaskLocation(node, taskId), fragment, initialSplits, totalPartitions, outputBuffers, this.httpClient, this.executor, this.updateScheduledExecutor, this.errorScheduledExecutor, this.maxErrorDuration, this.taskStatusRefreshMaxWait, this.taskInfoUpdateInterval, summarizeTaskInfo, this.taskStatusCodec, this.taskInfoCodec, this.taskUpdateRequestCodec, partitionedSplitCountTracker, this.stats, this.isBinaryTransportEnabled);
    }
}

