/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Failures;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public abstract class RowComparisonOperator
extends SqlOperator {
    protected RowComparisonOperator(OperatorType operatorType) {
        super(operatorType, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.orderableWithVariadicBound((String)"T", (String)"row")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"boolean"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T"), (Object)TypeSignature.parseTypeSignature((String)"T")));
    }

    protected List<MethodHandle> getMethodHandles(RowType type, FunctionManager functionManager, OperatorType operatorType) {
        ImmutableList.Builder argumentMethods = ImmutableList.builder();
        for (Type parameterType : type.getTypeParameters()) {
            FunctionHandle operatorHandle = functionManager.resolveOperator(operatorType, (List<? extends Type>)ImmutableList.of((Object)parameterType, (Object)parameterType));
            argumentMethods.add((Object)functionManager.getScalarFunctionImplementation(operatorHandle).getMethodHandle());
        }
        return argumentMethods.build();
    }

    protected static int compare(RowType rowType, List<MethodHandle> comparisonFunctions, Block leftRow, Block rightRow) {
        for (int i = 0; i < leftRow.getPositionCount(); ++i) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(leftRow.isNull(i), "null value at position " + i);
            com.facebook.presto.type.TypeUtils.checkElementNotNull(rightRow.isNull(i), "null value at position " + i);
            Type type = (Type)rowType.getTypeParameters().get(i);
            Object leftElement = TypeUtils.readNativeValue((Type)type, (Block)leftRow, (int)i);
            Object rightElement = TypeUtils.readNativeValue((Type)type, (Block)rightRow, (int)i);
            try {
                if (comparisonFunctions.get(i).invoke(leftElement, rightElement)) {
                    return 1;
                }
                if (!comparisonFunctions.get(i).invoke(rightElement, leftElement)) continue;
                return -1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0;
    }
}

