/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Failures;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.EQUAL)
public final class ArrayEqualOperator {
    private ArrayEqualOperator() {
    }

    @TypeParameter(value="E")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equals(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        boolean indeterminate = false;
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            if (leftArray.isNull(i) || rightArray.isNull(i)) {
                indeterminate = true;
                continue;
            }
            Object leftElement = TypeUtils.readNativeValue((Type)type, (Block)leftArray, (int)i);
            Object rightElement = TypeUtils.readNativeValue((Type)type, (Block)rightArray, (int)i);
            try {
                Boolean result = equalsFunction.invoke(leftElement, rightElement);
                if (result == null) {
                    indeterminate = true;
                    continue;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (indeterminate) {
            return null;
        }
        return true;
    }

    @TypeParameter(value="E")
    @TypeParameterSpecialization(name="E", nativeContainerType=long.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equalsLong(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        boolean indeterminate = false;
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            if (leftArray.isNull(i) || rightArray.isNull(i)) {
                indeterminate = true;
                continue;
            }
            long leftElement = type.getLong(leftArray, i);
            long rightElement = type.getLong(rightArray, i);
            try {
                Boolean result = equalsFunction.invokeExact(leftElement, rightElement);
                if (result == null) {
                    indeterminate = true;
                    continue;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (indeterminate) {
            return null;
        }
        return true;
    }

    @TypeParameter(value="E")
    @TypeParameterSpecialization(name="E", nativeContainerType=double.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equalsDouble(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block leftArray, @SqlType(value="array(E)") Block rightArray) {
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        boolean indeterminate = false;
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            if (leftArray.isNull(i) || rightArray.isNull(i)) {
                indeterminate = true;
                continue;
            }
            double leftElement = type.getDouble(leftArray, i);
            double rightElement = type.getDouble(rightArray, i);
            try {
                Boolean result = equalsFunction.invokeExact(leftElement, rightElement);
                if (result == null) {
                    indeterminate = true;
                    continue;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (indeterminate) {
            return null;
        }
        return true;
    }
}

