/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;

@ScalarFunction(value="array_distinct")
@Description(value="Remove duplicate values from the given array")
public final class ArrayDistinctFunction {
    private final PageBuilder pageBuilder;

    @TypeParameter(value="E")
    public ArrayDistinctFunction(@TypeParameter(value="E") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block distinct(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array) {
        if (array.getPositionCount() < 2) {
            return array;
        }
        if (array.getPositionCount() == 2) {
            if (TypeUtils.positionEqualsPosition(type, array, 0, array, 1)) {
                return array.getSingleValueBlock(0);
            }
            return array;
        }
        TypedSet typedSet = new TypedSet(type, array.getPositionCount(), "array_distinct");
        int distinctCount = 0;
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder distinctElementBlockBuilder = this.pageBuilder.getBlockBuilder(0);
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (typedSet.contains(array, i)) continue;
            typedSet.add(array, i);
            ++distinctCount;
            type.appendTo(array, i, distinctElementBlockBuilder);
        }
        this.pageBuilder.declarePositions(distinctCount);
        return distinctElementBlockBuilder.getRegion(distinctElementBlockBuilder.getPositionCount() - distinctCount, distinctCount);
    }

    @SqlType(value="array(bigint)")
    public Block bigintDistinct(@SqlType(value="array(bigint)") Block array) {
        if (array.getPositionCount() == 0) {
            return array;
        }
        boolean containsNull = false;
        LongOpenHashSet set = new LongOpenHashSet(array.getPositionCount());
        int distinctCount = 0;
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder distinctElementBlockBuilder = this.pageBuilder.getBlockBuilder(0);
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (array.isNull(i)) {
                if (containsNull) continue;
                containsNull = true;
                distinctElementBlockBuilder.appendNull();
                ++distinctCount;
                continue;
            }
            long value = BigintType.BIGINT.getLong(array, i);
            if (set.contains(value)) continue;
            set.add(value);
            ++distinctCount;
            BigintType.BIGINT.appendTo(array, i, distinctElementBlockBuilder);
        }
        this.pageBuilder.declarePositions(distinctCount);
        return distinctElementBlockBuilder.getRegion(distinctElementBlockBuilder.getPositionCount() - distinctCount, distinctCount);
    }
}

