/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.openjdk.jol.info.ClassLayout;

@NotThreadSafe
public class MergingPageOutput {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MergingPageOutput.class).instanceSize();
    private static final int MAX_MIN_PAGE_SIZE = 0x100000;
    private final List<Type> types;
    private final PageBuilder pageBuilder;
    private final Queue<Page> outputQueue = new LinkedList<Page>();
    private final long minPageSizeInBytes;
    private final int minRowCount;
    @Nullable
    private Iterator<Optional<Page>> currentInput;
    private boolean finishing;

    public MergingPageOutput(Iterable<? extends Type> types, long minPageSizeInBytes, int minRowCount) {
        this(types, minPageSizeInBytes, minRowCount, 0x100000);
    }

    public MergingPageOutput(Iterable<? extends Type> types, long minPageSizeInBytes, int minRowCount, int maxPageSizeInBytes) {
        this.types = ImmutableList.copyOf(Objects.requireNonNull(types, "types is null"));
        Preconditions.checkArgument((minPageSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"minPageSizeInBytes must be greater or equal than zero");
        Preconditions.checkArgument((minRowCount >= 0 ? 1 : 0) != 0, (Object)"minRowCount must be greater or equal than zero");
        Preconditions.checkArgument((maxPageSizeInBytes > 0 ? 1 : 0) != 0, (Object)"maxPageSizeInBytes must be greater than zero");
        Preconditions.checkArgument(((long)maxPageSizeInBytes >= minPageSizeInBytes ? 1 : 0) != 0, (Object)"maxPageSizeInBytes must be greater or equal than minPageSizeInBytes");
        Preconditions.checkArgument((minPageSizeInBytes <= 0x100000L ? 1 : 0) != 0, (String)"minPageSizeInBytes must be less or equal than %d", (int)0x100000);
        this.minPageSizeInBytes = minPageSizeInBytes;
        this.minRowCount = minRowCount;
        this.pageBuilder = PageBuilder.withMaxPageSize((int)maxPageSizeInBytes, this.types);
    }

    public boolean needsInput() {
        return this.currentInput == null && !this.finishing && this.outputQueue.isEmpty();
    }

    public void addInput(Iterator<Optional<Page>> input) {
        Objects.requireNonNull(input, "input is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"output is in finishing state");
        Preconditions.checkState((this.currentInput == null ? 1 : 0) != 0, (Object)"currentInput is present");
        this.currentInput = input;
    }

    @Nullable
    public Page getOutput() {
        if (!this.outputQueue.isEmpty()) {
            return this.outputQueue.poll();
        }
        while (this.currentInput != null) {
            Optional<Page> next;
            if (!this.currentInput.hasNext()) {
                this.currentInput = null;
                break;
            }
            if (!this.outputQueue.isEmpty() || !(next = this.currentInput.next()).isPresent()) break;
            this.process(next.get());
        }
        if (this.currentInput == null && this.finishing) {
            this.flush();
        }
        return this.outputQueue.poll();
    }

    public void finish() {
        this.finishing = true;
    }

    public boolean isFinished() {
        return this.finishing && this.currentInput == null && this.outputQueue.isEmpty() && this.pageBuilder.isEmpty();
    }

    private void process(Page page) {
        Objects.requireNonNull(page, "page is null");
        if (page.getSizeInBytes() >= this.minPageSizeInBytes || page.getPositionCount() >= this.minRowCount) {
            this.flush();
            this.outputQueue.add(page);
            return;
        }
        this.buffer(page);
    }

    private void buffer(Page page) {
        this.pageBuilder.declarePositions(page.getPositionCount());
        for (int channel = 0; channel < this.types.size(); ++channel) {
            Type type = this.types.get(channel);
            for (int position = 0; position < page.getPositionCount(); ++position) {
                type.appendTo(page.getBlock(channel), position, this.pageBuilder.getBlockBuilder(channel));
            }
        }
        if (this.pageBuilder.isFull()) {
            this.flush();
        }
    }

    private void flush() {
        if (!this.pageBuilder.isEmpty()) {
            Page output = this.pageBuilder.build();
            this.pageBuilder.reset();
            this.outputQueue.add(output);
        }
    }

    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = INSTANCE_SIZE;
        retainedSizeInBytes += this.pageBuilder.getRetainedSizeInBytes();
        for (Page page : this.outputQueue) {
            retainedSizeInBytes += page.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }
}

