/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.DigestAndPercentileState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.stats.QuantileDigest;

public class DigestAndPercentileStateSerializer
implements AccumulatorStateSerializer<DigestAndPercentileState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(DigestAndPercentileState state, BlockBuilder out) {
        if (state.getDigest() == null) {
            out.appendNull();
        } else {
            Slice serialized = state.getDigest().serialize();
            SliceOutput output = Slices.allocate((int)(12 + serialized.length())).getOutput();
            output.appendDouble(state.getPercentile());
            output.appendInt(serialized.length());
            output.appendBytes(serialized);
            VarbinaryType.VARBINARY.writeSlice(out, output.slice());
        }
    }

    public void deserialize(Block block, int index, DigestAndPercentileState state) {
        BasicSliceInput input = VarbinaryType.VARBINARY.getSlice(block, index).getInput();
        state.setPercentile(input.readDouble());
        int length = input.readInt();
        QuantileDigest digest = new QuantileDigest(input.readSlice(length));
        state.setDigest(digest);
        state.addMemoryUsage(state.getDigest().estimatedInMemorySizeInBytes());
    }
}

