/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.multimapagg;

import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggregationState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.ColumnarRow;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class MultimapAggregationStateSerializer
implements AccumulatorStateSerializer<MultimapAggregationState> {
    private final Type keyType;
    private final Type valueType;
    private final ArrayType arrayType;

    public MultimapAggregationStateSerializer(Type keyType, Type valueType) {
        this.keyType = Objects.requireNonNull(keyType);
        this.valueType = Objects.requireNonNull(valueType);
        this.arrayType = new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)valueType, (Object)keyType)));
    }

    public Type getSerializedType() {
        return this.arrayType;
    }

    public void serialize(MultimapAggregationState state, BlockBuilder out) {
        if (state.isEmpty()) {
            out.appendNull();
            return;
        }
        BlockBuilder entryBuilder = out.beginBlockEntry();
        state.forEach((keyBlock, valueBlock, position) -> {
            BlockBuilder rowBlockBuilder = entryBuilder.beginBlockEntry();
            this.valueType.appendTo(valueBlock, position, rowBlockBuilder);
            this.keyType.appendTo(keyBlock, position, rowBlockBuilder);
            entryBuilder.closeEntry();
        });
        out.closeEntry();
    }

    public void deserialize(Block block, int index, MultimapAggregationState state) {
        state.reset();
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)this.arrayType.getObject(block, index));
        Block keys = columnarRow.getField(1);
        Block values = columnarRow.getField(0);
        for (int i = 0; i < columnarRow.getPositionCount(); ++i) {
            state.add(keys, values, i);
        }
    }
}

