/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.arrayagg;

import com.facebook.presto.operator.aggregation.arrayagg.ArrayAggregationState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.Type;

public class ArrayAggregationStateSerializer
implements AccumulatorStateSerializer<ArrayAggregationState> {
    private final Type elementType;
    private final Type arrayType;

    public ArrayAggregationStateSerializer(Type elementType) {
        this.elementType = elementType;
        this.arrayType = new ArrayType(elementType);
    }

    public Type getSerializedType() {
        return this.arrayType;
    }

    public void serialize(ArrayAggregationState state, BlockBuilder out) {
        if (state.isEmpty()) {
            out.appendNull();
        } else {
            BlockBuilder entryBuilder = out.beginBlockEntry();
            state.forEach((block, position) -> this.elementType.appendTo(block, position, entryBuilder));
            out.closeEntry();
        }
    }

    public void deserialize(Block block, int index, ArrayAggregationState state) {
        state.reset();
        Block stateBlock = (Block)this.arrayType.getObject(block, index);
        for (int i = 0; i < stateBlock.getPositionCount(); ++i) {
            state.add(stateBlock, i);
        }
    }
}

