/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.Session;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.AccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.LambdaProvider;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class InternalAggregationFunction {
    private final String name;
    private final List<Type> parameterTypes;
    private final List<Type> intermediateType;
    private final Type finalType;
    private final List<Class> lambdaInterfaces;
    private final boolean decomposable;
    private final boolean orderSensitive;
    private final AccumulatorFactoryBinder factory;

    public InternalAggregationFunction(String name, List<Type> parameterTypes, List<Type> intermediateType, Type finalType, boolean decomposable, boolean orderSensitive, AccumulatorFactoryBinder factory) {
        this(name, parameterTypes, intermediateType, finalType, decomposable, orderSensitive, factory, (List<Class>)ImmutableList.of());
    }

    public InternalAggregationFunction(String name, List<Type> parameterTypes, List<Type> intermediateType, Type finalType, boolean decomposable, boolean orderSensitive, AccumulatorFactoryBinder factory, List<Class> lambdaInterfaces) {
        this.name = Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
        this.parameterTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameterTypes, "parameterTypes is null"));
        this.intermediateType = Objects.requireNonNull(intermediateType, "intermediateType is null");
        this.finalType = Objects.requireNonNull(finalType, "finalType is null");
        this.decomposable = decomposable;
        this.orderSensitive = orderSensitive;
        this.factory = Objects.requireNonNull(factory, "factory is null");
        this.lambdaInterfaces = ImmutableList.copyOf(lambdaInterfaces);
    }

    public String name() {
        return this.name;
    }

    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    public Type getFinalType() {
        return this.finalType;
    }

    public Type getIntermediateType() {
        if (this.intermediateType.size() == 1) {
            return (Type)Iterables.getOnlyElement(this.intermediateType);
        }
        return RowType.anonymous(this.intermediateType);
    }

    public List<Class> getLambdaInterfaces() {
        return this.lambdaInterfaces;
    }

    public boolean isDecomposable() {
        return this.decomposable;
    }

    public boolean isOrderSensitive() {
        return this.orderSensitive;
    }

    public AccumulatorFactory bind(List<Integer> inputChannels, Optional<Integer> maskChannel) {
        return this.factory.bind(inputChannels, maskChannel, (List<Type>)ImmutableList.of(), (List<Integer>)ImmutableList.of(), (List<SortOrder>)ImmutableList.of(), null, false, null, (List<LambdaProvider>)ImmutableList.of(), null);
    }

    public AccumulatorFactory bind(List<Integer> inputChannels, Optional<Integer> maskChannel, List<Type> sourceTypes, List<Integer> orderByChannels, List<SortOrder> orderings, PagesIndex.Factory pagesIndexFactory, boolean distinct, JoinCompiler joinCompiler, List<LambdaProvider> lambdaProviders, Session session) {
        return this.factory.bind(inputChannels, maskChannel, sourceTypes, orderByChannels, orderings, pagesIndexFactory, distinct, joinCompiler, lambdaProviders, session);
    }

    @VisibleForTesting
    public AccumulatorFactoryBinder getAccumulatorFactoryBinder() {
        return this.factory;
    }
}

